% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBCD_GAUSSIAN.R
\name{DBCD_GAUSSIAN}
\alias{DBCD_GAUSSIAN}
\title{Doubly Adaptive Biased Coin Design (Gaussian Responses)}
\usage{
DBCD_GAUSSIAN(Mean_RK,SD_RK, N_RK, group_allo, rho_func_index,
rho_func, alpha)
}
\arguments{
\item{Mean_RK}{A vector of current response means for each treatment arm.}

\item{SD_RK}{A vector of current response standard deviations for each
treatment arm.}

\item{N_RK}{A vector of current enrolled subjects in each arm. The length
must be the same as `Mean_RK`.}

\item{group_allo}{An integer of the size of group allocation. The default is
1.}

\item{rho_func_index}{Supply a number of 1 or 2 indicting the
allocation function to use.
1 = Zhang-Rosenberger allocation;
2 = Neyman allocation.
The default is 2.}

\item{rho_func}{Supply a user-specified allocation function of Mean_RK and
SD_RK when rho_func_index is NULL. Default is NULL.}

\item{alpha}{Supply a number indicating the subscripts of the probability
function. The default is 2.}
}
\value{
Number of the arm that the next subject is assigned to.
}
\description{
Allocates patients to one of treatments based on doubly adaptive
biased coin design on summarized data.
}
\details{
'DBCD_GAUSSIAN' assigns the next subject to a group given the observed
success rates, enrolled subjects and allocation function.
}
\examples{
# There are 2 arms each of which receives 10 patients.
# The observed response means are 4.5 and 5, respectively.
# The following command returns the number of arm that the next patient will
# be assigned to.
DBCD_GAUSSIAN(Mean_RK = c(4.5,5),
SD_RK = c(1.32,0.72),
N_RK = c(10,10),
rho_func_index = 2, alpha=2)

DBCD_GAUSSIAN(Mean_RK = c(4.5,5),
SD_RK = c(1.32,0.72),
N_RK = c(10,10),
rho_func_index = 1, alpha=2)

}
