% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addGoodCalib.R
\name{addGoodCalib}
\alias{addGoodCalib}
\title{Visualizes a measure for good calibration on the RBP curve.}
\usage{
addGoodCalib(
  obj,
  plot.values = TRUE,
  show.info = TRUE,
  col = grDevices::rgb(0, 0, 0, 0.25),
  border = NA,
  ...
)
}
\arguments{
\item{obj}{[\code{\link{RBPObj}}]\cr
Data container for RBP curve.}

\item{plot.values}{[\code{logical(1)}]\cr
Whether the values of the corresponding measure should be added to the plot?
Default is \code{FALSE}.}

\item{show.info}{[\code{logical(1)}]\cr
Print more information for the respective measure on console?
Default is \code{TRUE}.}

\item{col}{[\code{vector(1)}]\cr
Color for filling the polygon, as in \code{\link{polygon}}.
Default is \dQuote{grey}.}

\item{border}{[\code{vector(1)}]\cr
Color to draw the borders, as in \code{\link{polygon}}.
Default is \code{NA} to omit borders.}

\item{...}{[any]\cr
Passed to \code{\link{polygon}}.}
}
\value{
[\code{invisible(NULL)}].
}
\description{
The integral of the RBP curve is a measure for good calibration.
If the sum of the two integrals (below and above the RBP curve) is close to 0,
good calibration is satisfied and the prevalence is close to the average predicted probabilities.
}
