% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dnp_Test.R
\name{Dnp_Test}
\alias{Dnp_Test}
\title{Test for Independence in High-Dimensional Data}
\usage{
Dnp_Test(X)
}
\arguments{
\item{X}{the data. It must be matrix.}
}
\value{
a list with 2 elements:
\item{TestValue}{The value of test statistic}
\item{pval}{The p value}
\item{robust}{Logical. Indicates whether the results are based on robust
 statistic. Here, it returns \code{robust=FALSE}}
}
\description{
A Test Statistic for Independence in High-Dimensional Datasets
}
\details{
\code{Dnp_Test} function tests the complete independence in high-dimensional
data sets. This statistic was proposed by Najarzadeh (2021).
}
\examples{

# Under H0
library(MASS)
data_H0<-mvrnorm(n = 20,mu = rep(0,30),Sigma = diag(30))
Dnp_Test(data_H0)

# Under H1
library(MASS)
data_H1<-mvrnorm(n = 20,mu = rep(0,30),Sigma = (diag(30)+1))
Dnp_Test(data_H1)
}
\references{
Najarzadeg, D (2021). Testing independece in high-dimensional
 multivariate normal data, Communication in Statistics: Theory and Methods.
 50 (14): 3421-3435.
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
