% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_match_history_by_sequence_num.R
\name{get_match_history_by_sequence_num}
\alias{get_match_history_by_sequence_num}
\title{A list of Matches}
\usage{
get_match_history_by_sequence_num(start_at_match_seq_num = NULL,
  matches_requested = NULL, dota_id = "570", language = "en",
  key = NULL)
}
\arguments{
\item{start_at_match_seq_num}{(Optional) The match sequence number to start returning results
from.}

\item{matches_requested}{(Optional) The number of matches to return.}

\item{dota_id}{Can take one of three values.

\itemize{
 \item 570 - Dota 2 (default)
 \item 816 - Dota 2 Internal Test
 \item 205790 - Dota 2 Beta Test
}}

\item{language}{The ISO639-1 language code for returning all the information in the corresponding
language. If the language is not supported, english will be returned. For a complete list of the
ISO639-1 language codes please visit \url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}.}

\item{key}{The api key obtained from Steam. If you don't have one please visit
\url{https://steamcommunity.com/dev} in order to do so. For instructions on the correct way
to use this key please visit \url{https://github.com/LyzandeR/RDota2} and check the readme file.
You can also see the examples. A key can be made available to all the functions by using
\code{key_actions}. The key argument in individual functions should only be used in case the
user needs to work with multiple keys.}
}
\value{
A dota_api object containing the elements described in the details.
}
\description{
A list of matches ordered by a sequence number.
}
\details{
A list will be returned that contains three elements. The content, the url and the
response received from the api.

The content element of the list contains information about the matches. Each match follows
exactly the same structure as the match retrieved from get_match_details. Please check that
function's help for detailed information.
}
\section{Steam API Documentation}{

 \url{https://wiki.teamfortress.com/wiki/WebAPI/GetMatchHistoryBySequenceNum}
}
\examples{
\dontrun{
get_match_history_by_sequence_num()
get_match_history_by_sequence_num(matches_requested = 2, start_at_match_seq_num = 250)
get_match_history_by_sequence_num(language = 'en', key = NULL)
get_match_history_by_sequence_num(language = 'en', key = 'xxxxxxxxxxx')
}

}

