% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_team_info_by_team_id.R
\name{get_team_info_by_team_id}
\alias{get_team_info_by_team_id}
\title{Team Information}
\usage{
get_team_info_by_team_id(start_at_team_id = NULL, teams_requested = NULL,
  dota_id = 570, language = "en", key = NULL)
}
\arguments{
\item{start_at_team_id}{(optional) Team id to start returning results from .}

\item{teams_requested}{(optional) The number of teams to return.}

\item{dota_id}{Can take one of three values.

\itemize{
 \item 570 - Dota 2 (default)
 \item 816 - Dota 2 Internal Test
 \item 205790 - Dota 2 Beta Test
}}

\item{language}{The ISO639-1 language code for returning all the information in the corresponding
language. If the language is not supported, english will be returned. For a complete list of the
ISO639-1 language codes please visit \url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}.}

\item{key}{The api key obtained from Steam. If you don't have one please visit
\url{https://steamcommunity.com/dev} in order to do so. For instructions on the correct way
to use this key please visit \url{https://github.com/LyzandeR/RDota2} and check the readme file.
You can also see the examples. A key can be made available to all the functions by using
\code{key_actions}. The key argument in individual functions should only be used in case the
user needs to work with multiple keys.}
}
\value{
A dota_api object containing the elements described in the details.
}
\description{
Team information from team id.
}
\details{
A list will be returned that contains three elements. The content, the url and the response
received from the api.

The content element of the list contains the teams list of which each element is a team. For each
team different information is provided. Usually the following are included:

\itemize{
  \item \strong{name:} Team's name.
  \item \strong{tag:} The team's tag.
  \item \strong{time_created:} Unix timestamp of when the team was created.
  \item \strong{calibration_games_remaining: :} Undocumented (possibly number of games until
  a ranking score can be dedided).
  \item \strong{logo:} The UGC id for the team logo.
  \item \strong{logo_sponsor:} The UGC id for the team sponsor logo.
  \item \strong{country_code:} The team's ISO 3166-1 country-code.
  \item \strong{url:} Team's url which they provided.
  \item \strong{games_played:} Number of games played.
  \item \strong{player_*_account_id:} Player's account id. Will be as many columns as players.
  \item \strong{admin_account_id:} Team's admin id.
  \item \strong{league_id_*:} Undocumented (Probably leagues they participated in). Will be as
  many columns as leagues.
  \item \strong{series_type:} Series type.
  \item \strong{league_series_id:} The league series id.
  \item \strong{league_game_id:} The league game id.
  \item \strong{stage_name:} The name of the stage.
  \item \strong{league_tier:} League tier.
  \item \strong{scoreboard:} A huge list containing scoreboard information.
}
}
\section{Steam API Documentation}{

 \url{https://wiki.teamfortress.com/wiki/WebAPI/GetTeamInfoByTeamID}
}
\examples{
\dontrun{
get_team_info_by_team_id()
get_team_info_by_team_id(teams_requested = 10)
get_team_info_by_team_id(language = 'en', key = NULL)
get_team_info_by_team_id(language = 'en', key = 'xxxxxxxxxxx')
}

}

