% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_description_file}
\alias{write_description_file}
\alias{write_authors}
\title{Write DESCRIPTION File from REDCap Metadata}
\usage{
write_description_file(access_time, user, roles, project_info, path)

write_authors(user, roles = NULL)
}
\arguments{
\item{access_time}{The \code{Sys.time()} when the API calls were made}

\item{user}{User(s), as noted in the REDCap project meta data.  This
parameter is singular as it refers to the "user" content one can access from
the REDCap API.}

\item{roles}{roles the \code{user} hold with respect to the R data package.
These roles have no relationship to REDCap roles.}

\item{project_info}{project metadata}

\item{path}{path to the root for the generated R data package.}
}
\description{
Create the DESCRIPTION file for the R Data package based on an Exported
REDCap Project
}
\details{
This is a non-exported function and is not expected to be called by the end
user.

\code{write_description_file} creates the DESCRIPTION file for the
exported R data package and \code{write_authors} creates the "Authors@R"
field of the DESCRIPTION based on the "user" data extracted from the REDCap
project.
}
