% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-functions.R
\name{plot_redi}
\alias{plot_redi}
\title{Display the evolution of REDI over time and data points.}
\usage{
plot_redi(
  redi,
  plot_data = TRUE,
  x_axis = "Input",
  y_axis = "Output",
  alpha = 0.2,
  size = 1
)
}
\arguments{
\item{redi}{A tibble or data frame containing 4 mandatory columns : \code{Input},
\code{Output}, \code{REDI} and \code{Lambda}. One can use the \code{redi()}
function to get this tibble under the right format.}

\item{plot_data}{A boolean, indicating whether original data should be
displayed. Default is TRUE.}

\item{x_axis}{A character string, label of the x-axis. Default is 'Input'.}

\item{y_axis}{A character string, label of the y-axis. Default is 'Output'.}

\item{alpha}{A number, between 0 and 1, controlling the transparency of
data points. Default is 0.2.}

\item{size}{A number, controlling the size of the data points. Default is 1.}
}
\value{
Graph of the evolution of REDI over time, possibly for different
values of Lambda, along with the original data points.
}
\description{
Display the evolution of REDI over time and data points.
}
\examples{
TRUE
}
