% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.epplabOutlier.R
\docType{methods}
\name{plot.epplabOutlier}
\alias{plot.epplabOutlier}
\alias{plot,epplabOutlier-method}
\title{Plot for an epplabOutlier Object}
\usage{
\method{plot}{epplabOutlier}(x, col = c("white", "black"), outlier = TRUE, xlab = "", ylab = "", ...)
}
\arguments{
\item{x}{Object of class \code{epplabOutlier}.}

\item{col}{Which colors should be used for non-outliers and outliers.
Default is white and black.}

\item{outlier}{Logical if only observations considered as outliers at least
once should be plotted or all. Default is \code{TRUE}.
xlab Possible x axis label. Default is none.
ylab Possible x axis label. Default is none.}

\item{xlab}{Sets the x-axis label.}

\item{ylab}{Sets the y-axis label.}

\item{...}{Graphical parameters passed on to \code{\link{image}}.}
}
\description{
Visualizes which observations are considered as outliers and how often for
an \code{epplabOutlier} object.
}
\examples{

# creating data with 3 outliers
n <-300 
p <- 10
X <- matrix(rnorm(n*p),ncol=p)
X[1,1] <- 9
X[2,4] <- 7 
X[3,6] <- 8
# giving the data rownames, obs.1, obs.2 and obs.3 are the outliers.
rownames(X) <- paste("obs",1:n,sep=".")

PP<-EPPlab(X,PPalg="PSO",PPindex="KurtosisMax",n.simu=20, maxiter=20)
OUT<-EPPlabOutlier(PP, k = 3, location = median, scale = mad)
plot(OUT)

}
\seealso{
\code{\link{EPPlabOutlier}}, \code{\link{image}}
}
\author{
Daniel Fischer and Klaus Nordhausen
}
\keyword{hplot}
\keyword{methods}
