% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_repricing.R
\name{calculate_repricing}
\alias{calculate_repricing}
\title{Calculate repricing index based on hedonic model (geometric adjustment)}
\usage{
calculate_repricing(
  dataset,
  period_variable,
  dependent_variable,
  numerical_variables,
  categorical_variables,
  reference_period = NULL,
  number_of_observations = FALSE,
  periods_in_year = 4
)
}
\arguments{
\item{dataset}{a data frame containing the data}

\item{period_variable}{character name of the time period variable}

\item{dependent_variable}{character name of the dependent variable (e.g., sale price)}

\item{numerical_variables}{character vector of numeric quality-determining variables}

\item{categorical_variables}{character vector of categorical variables (including dummies)}

\item{reference_period}{reference period (numeric or string) to normalize index to 100}

\item{number_of_observations}{logical, if TRUE, adds number of observations column}

\item{periods_in_year}{if month, then 12. If quarter, then 4, etc. (default = 4)}
}
\value{
a data.frame with columns: period, Index, (optionally number_of_observations)
}
\description{
For each pair of subsequent periods, this method compares the observed geometric mean price
with the predicted mean price from a hedonic regression model. The ratio of these two values
forms the basis of the repricing growth rate, which is then accumulated into an index.
}
\author{
Vivek Gajadhar, Farley Ishaak
}
\keyword{internal}
