% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvFPM.R
\name{cvFPM}
\alias{cvFPM}
\title{Cross-Validation Optimization of the Floating Percentile Model}
\usage{
cvFPM(
  data,
  paramList,
  FN_crit = seq(0.1, 0.9, by = 0.05),
  alpha.test = seq(0.05, 0.5, by = 0.05),
  k = 5,
  seed = 1,
  plot = TRUE,
  which = c(1, 2, 3, 4),
  colors = heat.colors(10),
  colsteps = 100,
  ...
)
}
\arguments{
\item{data}{data.frame containing, at a minimum, chemical concentrations as columns and a logical \code{Hit} column classifying toxicity}

\item{paramList}{character vector of column names of chemical concentration variables in \code{data}}

\item{FN_crit}{numeric vector of values between 0 and 1 indicating false negative threshold for floating percentile model benchmark selection (default = \code{seq(0.1, 0.9, 0.05)})}

\item{alpha.test}{numeric vector of values between 0 and 1 indicating type-I error rate for chemical selection (default = \code{seq(0.05, 0.5, by = 0.05)})}

\item{k}{integer with length = 1 and value > 1 indicating how many folds to include in k-folds type cross-validation method (default = \code{5})}

\item{seed}{integer with length = 1 indicating the random seed to set for assigning k classes for k-folds cross-validation (default = \code{1})}

\item{plot}{whether to plot the output of \code{cvFPM} (default = \code{TRUE})}

\item{which}{numeric or character indicating which type of plot to generate (see Details; default = \code{c(1, 2, 3, 4)})}

\item{colors}{values recognizible as colors to be passed to \code{colorRampPalette} (via \code{colorGradient}) to generate a palette for plotting (default = \code{heat.colors(10)})}

\item{colsteps}{integer; number of discrete steps to interpolate colors in \code{colorGradient} (default = \code{100})}

\item{...}{additional arguments passed to \code{chemSig} and \code{FPM}}
}
\value{
data.frame of metric output, base R graphical output
}
\description{
Use leave-one-out (LOO) or k-folds cross-validation methods to calculate parameter inputs that optimize benchmark performance
while attempting to account for out-of-sample uncertainty
}
\details{
\code{cvFPM} allows users to "tune" the \code{FN_crit} and \code{alpha.test} arguments used by \code{FPM} (via \code{chemSig}). This is achieved by splitting the empirical dataset into "test" and "training" subsets,
calculating benchmarks for the training set, and then evaluating the benchmarks' ability to predict Hits in the out-of-sample test set. The output of \code{cvFPM} is similar to \code{optimFPM}: optimal \code{FN_crit} and \code{alpha.test} inputs
based on several classification metrics (see \code{?optimFPM} for more details). The key difference between \code{cvFPM} and \code{optimFPM} is that \code{cvFPM} attempts to account for
out-of-sample uncertainty, whereas \code{optimFPM} is specific (and potentially overly specific) to the full FPM dataset. Because the primary use of FPM SQBs will be to predict
toxicity in sediment samples where toxicity is not measured, the FPM should be parameterized in a way that best accounts for out-of-sample uncertainty. In other words, while FPM
generates classification metrics like "overall reliability" for SQBs, they are unlikely to achieve the expected reliability when applied to new samples. This is an inherent limitation of SQBs,
which the FPM cannot fully address but that \code{cvFPM} considers.

Two cross-validation methods are available, controlled through the \code{k} argument. If the user specifies \code{k = NULL} or \code{k = nrow(data)}, then leave-one-out (LOO) is used.
LOO is computationally intensive but is better suited to small datasets.
Other values of \code{k} (e.g., the default \code{k = 5}) will result in applying a k-folds cross-validation method, which uses larger test subsets (and smaller training sets),
evaluates fewer scenarios, and greatly improves runtime for large datasets. The \code{seed} argument can be used to establish a consistent result; if \code{is.null(seed)}, the result will vary based on randomization.
Allowing for randomization may be desireable to understand between-run variability in \code{cvFPM} output caused by re-sampling of training/test sets.

By setting \code{plot = TRUE} (the default), the outcome of cross-validation can be visualized over the range of \code{FN_crit} values considered. Visualizing the results
can inform the user about variability in the cross-validation process, ranges of potentially reasonable \code{FN_crit} values, etc. Graphical output depends on
whether many \code{FN_crit} and/or many \code{alpha.test} are evaluated, with line plots or heat plots alternately generated.

IMPORTANT: \code{cvFPM} is not in itself optimized for runtime - running \code{cvFPM} can take a long time

The \code{which} argument can be used to specify which of the metric-specific plots should be generated when \code{plot = TRUE}. Inputs
to \code{which} are, by default, \code{c(1, 2, 3, 4)}.
}
\examples{
paramList = c("Cd", "Cu", "Fe", "Mn", "Ni", "Pb", "Zn")
par(mfrow = c(2,2))
cvFPM(h.tristate, paramList, seq(0.1, 0.9, 0.1), 0.05)
}
\seealso{
chemSig, FPM, optimFPM
}
