% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{sample_toydata}
\alias{sample_toydata}
\title{Sample Toydata}
\usage{
sample_toydata(n = 1000, sd = 0.3, seed = 20211111)
}
\arguments{
\item{n}{Number of observations to generate}

\item{sd}{Standard deviation of the normal distribution to generate y}

\item{seed}{A seed for the pseudo random number generator}
}
\value{
A matrix with two columns x and y
}
\description{
Sample Toydata to reproduce the examples in the paper.
}
\examples{
\dontrun{
# Before running the first time the torch backend needs to be installed
torch::install_torch()
# Load data
data <- sample_toydata()
# Build new transformer
transformer <- data_transformer$new()
# Fit transformer to data
transformer$fit(data)
# Transform data and store as new object
transformed_data <-  transformer$transform(data)
# Train the default GAN
trained_gan <- gan_trainer(transformed_data)
# Sample synthetic data from the trained GAN
synthetic_data <- sample_synthetic_data(trained_gan, transformer)
# Plot the results
GAN_update_plot(data = data,
synth_data = synthetic_data,
main = "Real and Synthetic Data after Training")
}
}
