% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgammatr.R
\name{rgammatr}
\alias{rgammatr}
\title{Random generator for a Truncated Gamma distribution.}
\usage{
rgammatr(n = 1, A = 0, B = 1, range = NULL)
}
\arguments{
\item{n}{int, optional \cr
number of simulations.}

\item{A}{double, optional \cr
shape parameter of the distribution.}

\item{B}{double, optional \cr
rate parameter of the distribution.}

\item{range}{array_like, optional \cr
domain of the distribution, where we truncate our
Gamma. \eqn{range(0)} is the min of the range and
\eqn{range(1)} is the max of the range.}
}
\value{
\code{rgammatr} returns the simulated value of the distribution:

\item{u}{  double \cr
           it is the simulated value of the truncated Gamma
           distribution. It will be a value in \eqn{(range(0),range(1))}.
            }
}
\description{
Simulate random number from a truncated Gamma distribution.
}
\details{
It provide a way to simulate from a truncated Gamma distribution with
given pameters \eqn{A,B} and range \eqn{range}. This will be used
during the posterior sampling in th Gibbs sampler.
}
\examples{
#Simulate a truncated Gamma with parameters 1,2 in the range
#1,5.
#Set the range:
range<- c(1,5)

#Simulate the truncated Gamma
set.seed(123)
vars1<-rgammatr(1000,1,2,range)

#Look at the histogram
hist(vars1,freq=FALSE,ylim=c(0,2),xlim = c(0,5))
lines(density(vars1))

#Compare with a non truncated Gamma
set.seed(123)
vars2<-rgamma(1000,1,2)


#Compare the two results
lines(density(vars2),col='red')

#Observation: simulate without range is equivalent to simulate from
#rgamma(1000,1,2)

}
\references{
\itemize{

 \item   [1] Y. Wang, A. Canale, D. Dunson.
         "Scalable Geometric Density Estimation" (2016).\cr
         The implementation of rgammatr is inspired to the Matlab
         implementation of gamrndtruncated by Ye Wang.
}
}
\author{
L. Rimella, \email{lorenzo.rimella@hotmail.it}
}
