% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RHC.R
\name{plot_RHC}
\alias{plot_RHC}
\title{Create Evaluation Criteria Plots}
\usage{
plot_RHC(evaluation.criteria, selected_columns = NULL, ncol = 4)
}
\arguments{
\item{evaluation.criteria}{A data frame containing standardized data from the first function.}

\item{selected_columns}{A vector of column indices specifying which criteria to plot. If NULL, all columns will be plotted.}

\item{ncol}{Number of columns for arranging the plots. Default is 4.}

\item{plot_RHC}{A function that takes standardized data and generates evaluation plots for different criteria of landscape function analysis (LFA), rangeland health and condition.}
}
\value{
A list of evaluation criteria(attributes) plots.
}
\description{
This function creates plots to compare evaluation criteria of landscape function analysis (LFA), rangeland health and condition.
}
\details{
The function takes the output from RHC_function and creates evaluation plots for different criteria.
}
\examples{
data(canopy_oc_file)
data(trait_file)
final_data_st <- prepare_RHC_data(canopy_oc_file, trait_file)
evaluation.criteria <- RHC_function(final_data_st)
# Plot all columns
plots_all <- plot_RHC(evaluation.criteria, ncol = 4)
# Plot specific columns
selected_columns <- c(4, 8)
plots_selected <- plot_RHC(evaluation.criteria, selected_columns, ncol = 2)
}
