% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_samples.R
\name{plot_samples}
\alias{plot_samples}
\title{Plot Samples}
\arguments{
\item{final_data_st}{A data frame containing standardized data from the first function.}

\item{row_indices}{A vector of row indices specifying which rows to use for creating sample plots.}

\item{plot_title_prefix}{A prefix for the plot titles (default is "Sample").}

\item{ncol}{Number of columns for arranging the plots. Default is 3.}
}
\value{
A list of sample charts.
}
\description{
This function creates graphs for the inputs of the RHC_function model.
}
\details{
The function takes input data and specific row indices, creates sample charts, and returns the plots.
}
\examples{
data(canopy_oc_file)
data(trait_file)
final_data_st <- prepare_RHC_data(canopy_oc_file, trait_file)
row_indices <- 1:17
plots.samples <- plot_samples(final_data_st, row_indices, plot_title_prefix = "Sample", ncol = 3)
}
