% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prepare_RHC_Data.R
\name{prepare_RHC_data}
\alias{prepare_RHC_data}
\title{Prepare Input Data}
\usage{
prepare_RHC_data(canopy_oc_file, trait_file)
}
\arguments{
\item{canopy_oc_file}{A data frame containing canopy cover and soil organic carbon data.}

\item{trait_file}{A data frame containing plant species trait data.}
}
\value{
A standardized data frame for further analysis using Min-Max Normalization.
}
\description{
This function prepares input data for the evaluation criteria of landscape function analysis (LFA), rangeland health and condition.
}
\details{
The function takes canopy cover, soil organic carbon (OC), and plant species trait data, and returns standardized data.

\strong{Note:} The first row of the input data matrix (canopy_oc_file) must be the reference sample, and the second column must contain the OC data, and the canopy cover must be entered as a relative value.
}
\examples{
data(canopy_oc_file)
data(trait_file)
final_data_st <- prepare_RHC_data(canopy_oc_file, trait_file)
}
