% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilOutputReport.R
\name{UtilOutputReport}
\alias{UtilOutputReport}
\title{Generate a text formatted report file or an Excel file}
\usage{
UtilOutputReport(
  dataset,
  ReportFileBaseName = NULL,
  ReportFileExt = "txt",
  method = "DBM",
  FOM,
  alpha = 0.05,
  covEstMethod = "jackknife",
  nBoots = 200,
  sequentialNames = FALSE,
  overWrite = FALSE,
  analysisOption = "ALL"
)
}
\arguments{
\item{dataset}{The dataset object to be analyzed (\emph{not the file name}), 
see \code{Dataset} in \code{\link{RJafroc-package}}.}

\item{ReportFileBaseName}{The report file (with extension \code{"txt"} or \code{"xlsx"}, 
as specified by option 
\code{ReportFileExt}) 
is created \bold{in the user's directory}. 
This argument specifies the 
report file base name (i.e., without the extension) for the 
desired report; the default is NULL, in which case the system generates 
a temporary text file, whose very long name is displayed. However, the 
file
is very hard to locate. This is so that the software passes CRAN checks, 
as writing to the project directory, or any of its sub-directories, is 
frowned upon.}

\item{ReportFileExt}{The report file extension determines the type of output. 
\code{"txt"}, the default, for 
a text file, \code{"xlsx"} for an Excel file.}

\item{method}{The significance testing method, \code{"OR"} or 
(the default) \code{"DBM"}.}

\item{FOM}{The figure of merit; see \code{\link{StSignificanceTesting}}.}

\item{alpha}{See \code{\link{StSignificanceTesting}}; the default is 0.05.}

\item{covEstMethod}{See \code{\link{StSignificanceTesting}}; only needed 
for method = \code{"OR"}; the default is "Jackknife".}

\item{nBoots}{See \code{\link{StSignificanceTesting}}; only needed for 
\code{"OR"} analysis; the default is 200.}

\item{sequentialNames}{A logical variable: if \code{TRUE}, consecutive integers 
(starting from 1) will be used as the treatment and reader IDs in the 
output report. Otherwise, treatment and reader IDs in the original dataset 
are used. This option is needed for aesthetics, as long names can mess
up the output. The default is \code{FALSE.}}

\item{overWrite}{A \code{logical} variable: if \code{FALSE}, a warning will 
be issued if the report file already exists and the program will wait 
until the user inputs "y" or "n" to determine whether to overwrite the 
existing file. If \code{TRUE}, the existing file will be silently overwritten. 
The default is \code{FALSE}.}

\item{analysisOption}{"RRRC", "FRRC", "RRFC or "ALL"; see \code{\link{StSignificanceTesting}}.}
}
\value{
StResult The object returned by \code{\link{StSignificanceTesting}}.
}
\description{
Generates a formatted report of the analysis 
   and saves it to a text or an Excel file
}
\details{
A formatted report of the data analysis is written to the output file in 
   either text or Excel format.
}
\examples{

\donttest{
 # text output is created in a temporary file
UtilOutputReport(dataset03, FOM = "Wilcoxon")
# Excel output is created in a temporary file
UtilOutputReport(dataset03, FOM = "Wilcoxon", ReportFileExt = "xlsx") 

}
       
}
