/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.uuid;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class MD5 {
    private static final int BUFFER_SIZE = 1024;
    private static final int S11 = 7;
    private static final int S12 = 12;
    private static final int S13 = 17;
    private static final int S14 = 22;
    private static final int S21 = 5;
    private static final int S22 = 9;
    private static final int S23 = 14;
    private static final int S24 = 20;
    private static final int S31 = 4;
    private static final int S32 = 11;
    private static final int S33 = 16;
    private static final int S34 = 23;
    private static final int S41 = 6;
    private static final int S42 = 10;
    private static final int S43 = 15;
    private static final int S44 = 21;
    private static byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private InputStream in = null;
    private boolean stringp = false;
    private int[] state = null;
    private long count = 0L;
    private byte[] buffer = null;
    private byte[] digest = null;

    private static String stringify(byte[] buf) {
        StringBuffer sb = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            int h = (buf[i] & 0xF0) >> 4;
            int l = buf[i] & 0xF;
            sb.append(new Character((char)(h > 9 ? 97 + h - 10 : 48 + h)));
            sb.append(new Character((char)(l > 9 ? 97 + l - 10 : 48 + l)));
        }
        return sb.toString();
    }

    private final int F(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private final int G(int x, int y, int z) {
        return x & z | y & ~z;
    }

    private final int H(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private final int I(int x, int y, int z) {
        return y ^ (x | ~z);
    }

    private final int rotate_left(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    private final int FF(int a, int b, int c, int d, int x, int s, int ac) {
        a += this.F(b, c, d) + x + ac;
        a = this.rotate_left(a, s);
        return a += b;
    }

    private final int GG(int a, int b, int c, int d, int x, int s, int ac) {
        a += this.G(b, c, d) + x + ac;
        a = this.rotate_left(a, s);
        return a += b;
    }

    private final int HH(int a, int b, int c, int d, int x, int s, int ac) {
        a += this.H(b, c, d) + x + ac;
        a = this.rotate_left(a, s);
        return a += b;
    }

    private final int II(int a, int b, int c, int d, int x, int s, int ac) {
        a += this.I(b, c, d) + x + ac;
        a = this.rotate_left(a, s);
        return a += b;
    }

    private final void decode(int[] output, byte[] input, int off, int len) {
        int i = 0;
        for (int j = 0; j < len; j += 4) {
            output[i] = input[off + j] & 0xFF | (input[off + j + 1] & 0xFF) << 8 | (input[off + j + 2] & 0xFF) << 16 | (input[off + j + 3] & 0xFF) << 24;
            ++i;
        }
    }

    private final void transform(byte[] block, int offset) {
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        int[] x = new int[16];
        this.decode(x, block, offset, 64);
        a = this.FF(a, b, c, d, x[0], 7, -680876936);
        d = this.FF(d, a, b, c, x[1], 12, -389564586);
        c = this.FF(c, d, a, b, x[2], 17, 606105819);
        b = this.FF(b, c, d, a, x[3], 22, -1044525330);
        a = this.FF(a, b, c, d, x[4], 7, -176418897);
        d = this.FF(d, a, b, c, x[5], 12, 1200080426);
        c = this.FF(c, d, a, b, x[6], 17, -1473231341);
        b = this.FF(b, c, d, a, x[7], 22, -45705983);
        a = this.FF(a, b, c, d, x[8], 7, 1770035416);
        d = this.FF(d, a, b, c, x[9], 12, -1958414417);
        c = this.FF(c, d, a, b, x[10], 17, -42063);
        b = this.FF(b, c, d, a, x[11], 22, -1990404162);
        a = this.FF(a, b, c, d, x[12], 7, 1804603682);
        d = this.FF(d, a, b, c, x[13], 12, -40341101);
        c = this.FF(c, d, a, b, x[14], 17, -1502002290);
        b = this.FF(b, c, d, a, x[15], 22, 1236535329);
        a = this.GG(a, b, c, d, x[1], 5, -165796510);
        d = this.GG(d, a, b, c, x[6], 9, -1069501632);
        c = this.GG(c, d, a, b, x[11], 14, 643717713);
        b = this.GG(b, c, d, a, x[0], 20, -373897302);
        a = this.GG(a, b, c, d, x[5], 5, -701558691);
        d = this.GG(d, a, b, c, x[10], 9, 38016083);
        c = this.GG(c, d, a, b, x[15], 14, -660478335);
        b = this.GG(b, c, d, a, x[4], 20, -405537848);
        a = this.GG(a, b, c, d, x[9], 5, 568446438);
        d = this.GG(d, a, b, c, x[14], 9, -1019803690);
        c = this.GG(c, d, a, b, x[3], 14, -187363961);
        b = this.GG(b, c, d, a, x[8], 20, 1163531501);
        a = this.GG(a, b, c, d, x[13], 5, -1444681467);
        d = this.GG(d, a, b, c, x[2], 9, -51403784);
        c = this.GG(c, d, a, b, x[7], 14, 1735328473);
        b = this.GG(b, c, d, a, x[12], 20, -1926607734);
        a = this.HH(a, b, c, d, x[5], 4, -378558);
        d = this.HH(d, a, b, c, x[8], 11, -2022574463);
        c = this.HH(c, d, a, b, x[11], 16, 1839030562);
        b = this.HH(b, c, d, a, x[14], 23, -35309556);
        a = this.HH(a, b, c, d, x[1], 4, -1530992060);
        d = this.HH(d, a, b, c, x[4], 11, 1272893353);
        c = this.HH(c, d, a, b, x[7], 16, -155497632);
        b = this.HH(b, c, d, a, x[10], 23, -1094730640);
        a = this.HH(a, b, c, d, x[13], 4, 681279174);
        d = this.HH(d, a, b, c, x[0], 11, -358537222);
        c = this.HH(c, d, a, b, x[3], 16, -722521979);
        b = this.HH(b, c, d, a, x[6], 23, 76029189);
        a = this.HH(a, b, c, d, x[9], 4, -640364487);
        d = this.HH(d, a, b, c, x[12], 11, -421815835);
        c = this.HH(c, d, a, b, x[15], 16, 530742520);
        b = this.HH(b, c, d, a, x[2], 23, -995338651);
        a = this.II(a, b, c, d, x[0], 6, -198630844);
        d = this.II(d, a, b, c, x[7], 10, 1126891415);
        c = this.II(c, d, a, b, x[14], 15, -1416354905);
        b = this.II(b, c, d, a, x[5], 21, -57434055);
        a = this.II(a, b, c, d, x[12], 6, 1700485571);
        d = this.II(d, a, b, c, x[3], 10, -1894986606);
        c = this.II(c, d, a, b, x[10], 15, -1051523);
        b = this.II(b, c, d, a, x[1], 21, -2054922799);
        a = this.II(a, b, c, d, x[8], 6, 1873313359);
        d = this.II(d, a, b, c, x[15], 10, -30611744);
        c = this.II(c, d, a, b, x[6], 15, -1560198380);
        b = this.II(b, c, d, a, x[13], 21, 1309151649);
        a = this.II(a, b, c, d, x[4], 6, -145523070);
        d = this.II(d, a, b, c, x[11], 10, -1120210379);
        c = this.II(c, d, a, b, x[2], 15, 718787259);
        b = this.II(b, c, d, a, x[9], 21, -343485551);
        this.state[0] = this.state[0] + a;
        this.state[1] = this.state[1] + b;
        this.state[2] = this.state[2] + c;
        this.state[3] = this.state[3] + d;
    }

    private final void update(byte[] input, int len) {
        int index = (int)(this.count >> 3) & 0x3F;
        this.count += (long)(len << 3);
        int partLen = 64 - index;
        int i = 0;
        if (len >= partLen) {
            System.arraycopy(input, 0, this.buffer, index, partLen);
            this.transform(this.buffer, 0);
            i = partLen;
            while (i + 63 < len) {
                this.transform(input, i);
                i += 64;
            }
            index = 0;
        } else {
            i = 0;
        }
        System.arraycopy(input, i, this.buffer, index, len - i);
    }

    private byte[] end() {
        byte[] bits = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bits[i] = (byte)(this.count >>> i * 8 & 0xFFL);
        }
        int index = (int)(this.count >> 3) & 0x3F;
        int padlen = index < 56 ? 56 - index : 120 - index;
        this.update(padding, padlen);
        this.update(bits, 8);
        return this.encode(this.state, 16);
    }

    private byte[] encode(int[] input, int len) {
        byte[] output = new byte[len];
        int i = 0;
        for (int j = 0; j < len; j += 4) {
            output[j] = (byte)(input[i] & 0xFF);
            output[j + 1] = (byte)(input[i] >> 8 & 0xFF);
            output[j + 2] = (byte)(input[i] >> 16 & 0xFF);
            output[j + 3] = (byte)(input[i] >> 24 & 0xFF);
            ++i;
        }
        return output;
    }

    public byte[] getDigest() throws IOException {
        byte[] buffer = new byte[1024];
        int got = -1;
        if (this.digest != null) {
            return this.digest;
        }
        while ((got = this.in.read(buffer)) > 0) {
            this.update(buffer, got);
        }
        this.digest = this.end();
        return this.digest;
    }

    public byte[] processString() {
        if (!this.stringp) {
            throw new RuntimeException(this.getClass().getName() + "[processString]" + " not a string.");
        }
        try {
            return this.getDigest();
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getClass().getName() + "[processString]" + ": implementation error.");
        }
    }

    public String getStringDigest() {
        if (this.digest == null) {
            throw new RuntimeException(this.getClass().getName() + "[getStringDigest]" + ": called before processing.");
        }
        return MD5.stringify(this.digest);
    }

    public MD5(String input, String enc) {
        byte[] bytes = null;
        try {
            bytes = input.getBytes(enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("no " + enc + " encoding!!!");
        }
        this.stringp = true;
        this.in = new ByteArrayInputStream(bytes);
        this.state = new int[4];
        this.buffer = new byte[64];
        this.count = 0L;
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
    }

    public MD5(String input) {
        this(input, "UTF8");
    }

    public MD5(InputStream in) {
        this.stringp = false;
        this.in = in;
        this.state = new int[4];
        this.buffer = new byte[64];
        this.count = 0L;
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("MD5 <file>");
            System.exit(1);
        }
        MD5 md5 = new MD5(new FileInputStream(new File(args[0])));
        byte[] b = md5.getDigest();
        System.out.println(MD5.stringify(b));
    }
}

