% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_pars.R
\name{.set_pars}
\alias{.set_pars}
\title{Set parameters for Different Quartz Luminescence Models}
\usage{
.set_pars(model)
}
\arguments{
\item{model}{\link{character} (\bold{required}): set model to be used.
Available models are: \code{"Bailey2001"}, \code{"Bailey2002"}, \code{"Bailey2004"}, \code{"Pagonis2007"},
\code{"Pagonis2008"}, \code{"Friedrich2017"}, \code{"Friedrich2018"}, \code{"Peng2022"}. If model is indeed missing,
the list of allowed keywords is returned.}
}
\value{
This function returns a \link{list} with all necessary parameters for
the used model. Returns vector of allowed keywords if model is missing.
}
\description{
This function provides all necessary model parameters to the
calculation of the ODEs.
}
\details{
The common model parameters are:

\bold{N}: concentrations of electron/hole traps in cm^(-3)
\bold{E}: depth of the electron/hole trap in eV
\bold{s}: frequency factor in s^(-1)
\bold{A}: conduction band to electron/hole trap transition probability in s^(-1)
\bold{B}: valence band to hole trap transition probability in s^(-1)
\bold{Th}: photo-ionisation cross-section in s^(-1)
\bold{E_th}: thermal assistance energy in (eV)
\bold{n}: concentrations of electron/hole traps after sample history in cm^(-3)
}
\note{
\bold{n} are the saved concentrations of the last step of the sample history
of the used model. They will be loaded, if \code{simulate_sample_history = FALSE} in
\link{model_LuminescenceSignals} is chosen.

The order of the energy-band-levels is sometimes in an different order than in the original model.
This was necessary, because in the simulations the luminescence centre always
has to be the last entry in every parameter.
Another reason was the clear division between electron traps and hole centres.
When a user wants to create his/her own parameter sets he/she only has to take care that the
luminescence centre is the last entry in every vector and that the first entries
are the electron traps and the last entries the hole centres.
}
\section{Function version}{
 0.1.3
}

\examples{

pars <- .set_pars("Bailey2001")

} 

\section{How to cite}{
Friedrich, J., 2025. .set_pars(): Set parameters for Different Quartz Luminescence Models. Function version 0.1.3. In: Friedrich, J., Kreutzer, S., Schmidt, C., 2025. RLumModel: Solving Ordinary Differential Equations to Understand Luminescence. R package version 0.2.11. https://CRAN.R-project.org/package=RLumModel
}

\references{
Bailey, R.M., 2001. Towards a general kinetic model for optically and thermally stimulated
luminescence of quartz. Radiation Measurements 33, 17-45.

Bailey, R.M., 2002. Simulations of variability in the luminescence characteristics of natural
quartz and its implications for estimates of absorbed dose.
Radiation Protection Dosimetry 100, 33-38.

Bailey, R.M., 2004. Paper I-simulation of dose absorption in quartz over geological timescales
and its implications for the precision and accuracy of optical dating.
Radiation Measurements 38, 299-310.

Friedrich, J., Pagonis, V., Chen, R., Kreutzer, S., Schmidt, C., 2017: Quartz radiofluorescence: a modelling approach.
Journal of Luminescence 186, 318-325.

Pagonis, V., Chen, R., Wintle, A.G., 2007. Modelling thermal transfer in optically
stimulated luminescence of quartz. Journal of Physics D: Applied Physics 40, 998-1006.

Pagonis, V., Wintle, A.G., Chen, R., Wang, X.L., 2008. A theoretical model for a new dating protocol
for quartz based on thermally transferred OSL (TT-OSL).
Radiation Measurements 43, 704-708.

Peng, J., Wang, X., Adamiec, G., 2022. The build-up of the laboratory-generated dose-response curve and underestimation of equivalent dose for quartz OSL in the high dose region: A critical modelling study. Quaternary Geochronology 67, 101231.
}
\author{
Johannes Friedrich, University of Bayreuth (Germany),
}
