% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{RME_beta}
\alias{RME_beta}
\title{Generate an ensemble of random beta matrices}
\usage{
RME_beta(N, beta, size)
}
\arguments{
\item{N}{number of dimensions of the square matrix}

\item{beta}{the value of the beta parameter for the beta ensemble}

\item{size}{the size of the ensemble (i.e. number of matrices)}
}
\value{
An ensemble (list) of beta matrices as specified by the matrix arguments.
}
\description{
Given the same arguments as RM_norm, this function returns an ensemble of that particular class of matrix.
  While random matrices usually do not exude unique properties on their own, they do indeed have
  deterministic properties at the ensemble level in terms of their spectral statistics.
}
\examples{
# Generate an ensemble of 10x10 beta matrices with beta = 4 of size 100.
ensemble <- RME_beta(N = 10, beta = 4, size = 100)

}
