% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{RM_erdos}
\alias{RM_erdos}
\title{Generate a random stochastic matrix for a walk on an Erdos-Renyi graph}
\usage{
RM_erdos(N, p)
}
\arguments{
\item{N}{number of dimensions of the square matrix}

\item{p}{the probability two vertices are connected in an Erdos-Renyi graph.}
}
\value{
A random stochastic matrix corrosponding to a walk on an Erdos-Renyi graph with probability p.
}
\description{
An Erdos-Renyi Graph is a graph whose edges are connected ~ Bern(p).
 Hence, its transition matrix will have nonzero entries with that probability.
 So, we can alternatively think of the transition matrix for such walk as a stochastic matrix with parameterized sparsity.
}
\examples{
# Very sparse graph
P <- RM_erdos(N = 3, p = 0.2)

# Slightly sparse graph
P <- RM_erdos(N = 9, p = 0.6)

# Completely connected graph
P <- RM_erdos(N = 5, p = 1)

}
