% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMART.R
\name{apply.SMART}
\alias{apply.SMART}
\title{Apply the SMART Method}
\usage{
apply.SMART(dataset, grades, lower, upper, beneficial.vector)
}
\arguments{
\item{dataset}{A numeric matrix or data frame of size (n x m), rows = alternatives, columns = criteria.}

\item{grades}{A numeric vector of length \code{m} (one grade per criterion).
They get transformed into weights via \eqn{(2^{1/2})^{grades}} and normalized.}

\item{lower}{A numeric vector of length \code{m} with lower bounds for each criterion.}

\item{upper}{A numeric vector of length \code{m} with upper bounds for each criterion.}

\item{beneficial.vector}{A numeric vector containing column indices that are beneficial ("max").}
}
\value{
A matrix (or data frame) named result with two columns: The row index (alternative)
and the final SMART score for that alternative.

The rows of result are sorted by score in descending order.
}
\description{
This function implements the SMART (Simple Multi-Attribute Rating Technique) method in R.
}
\examples{
# Example usage
data_mat <- matrix(c(10, 20, 15,  7,
                     30,  5,  8, 25),
                   nrow = 2, byrow = TRUE)
# Suppose we have 4 criteria (2 rows, 4 columns)
# We'll treat columns 1, 2, 3 as beneficial, and column 4 as non-beneficial
benef_vec <- c(1, 2, 3)

# Grades for each of 4 criteria
grades <- c(2, 2, 1, 3)
lower  <- c(0, 0, 0,  0)
upper  <- c(40, 40, 40, 40)

# Run SMART
result <- apply.SMART(dataset = data_mat,
                    grades = grades,
                    lower  = lower,
                    upper  = upper,
                    beneficial.vector = benef_vec)

result

}
