% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{RMFM}
\alias{RMFM}
\title{Fit the high-dimensional robust matrix factor model}
\usage{
RMFM(
  X,
  r1 = 10,
  r2 = 10,
  epsELBO = 1e-09,
  maxIter = 30,
  verbose = TRUE,
  seed = 1,
  cal_eigs = FALSE
)
}
\arguments{
\item{X}{a  p1* p2*T array, which is the observed  matrix from each individual, where T is the sample size.}

\item{r1}{an optional positive integer, specify the number of row factors; default as 10.}

\item{r2}{an optional positive integer, specify the number of column factors; default as 10.}

\item{epsELBO}{an optional positive value, tolerance of relative variation rate of the variational lower bound value, default as '1e-9'.}

\item{maxIter}{the maximum iteration of the VEM algorithm. The default is 30.}

\item{verbose}{a logical value, whether output the information in iteration.}

\item{seed}{an optional integer, specify the random seed for reproducibility in initialization.}

\item{cal_eigs}{an optional logical value, specify whether calculate the eigenvalues of covariance matrix, default as \code{FALSE}.}
}
\value{
return a list including the following components:
\itemize{
  \item \code{hF} - a r1* r2*T array, which is the estimated factor  matrix for each individual, where T is the sample size.
  \item \code{hmu} - a p1-by-p2 matrix, the estimated mean matrix.
  \item \code{hR} - the estimated row  loading matrix.
  \item \code{hC} - the estimated column loading matrix.
  \item \code{hnu} - the estimated degree of freedom for the error term.
  \item \code{hLambda1} - a p1 vector, the estimated row scatter matrix for error.
  \item \code{hLambda2} - a p2 vector, the estimated column scatter matrix for error.
  \item \code{dR} - \code{NULL} if \code{cal_eigs=FALSE}; a group of eigenvalues of the  sample covariance across rows if \code{cal_eigs=TRUE}.
  \item \code{dC} - \code{NULL} if \code{cal_eigs=FALSE}; a group of eigenvalues of the  sample covariance across columns if \code{cal_eigs=TRUE}.
  \item \code{ELBO} -  the ELBO value when algorithm stops;
  \item \code{ELBO_seq} - the sequence of ELBO values.
  \item \code{time_use} - the running time in model fitting of RMFM;
}
}
\description{
Fit the high-dimensional robust matrix factor model via variational inference.
}
\details{
None
}
\examples{
r1 <- 4; r2 <- 3;
Tt <- 100; type <- 'MatrixT'
p1 <- 50; p2 <- 50
datlist <- gendata_rmfm(Tt = Tt,p1 =p1, p2=p2, r1=r1, r2=r2,
                        rho=1, type= 'MatrixT', nu=1)
str(datlist)
reslist <- RMFM(X=datlist$X, r1=r1, r2=r2,  verbose = TRUE, maxIter = 6)
}
\references{
None
}
\seealso{
None
}
