% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.czek_matrix.R
\name{plot.czek_matrix}
\alias{plot.czek_matrix}
\title{Produce a Czekanowski's Diagram}
\usage{
\method{plot}{czek_matrix}(
  x,
  values = NULL,
  type = "symbols",
  plot_title = "Czekanowski's diagram",
  tl.cex = 1,
  tl.offset = 0.4,
  tl.srt = 90,
  pal = brewer.pal(n = 8, name = "Dark2"),
  alpha = 0.3,
  ps_power = 0.6,
  col_size = 1,
  cex.main = 1,
  ...
)
}
\arguments{
\item{x}{a matrix with class czek_matrix.}

\item{values}{specifies the color or the size of the symbols in the graph. The standard setting is a grey scale for a color graph and a vector with the values 2,1,0.5,0.25 and 0 for a graph with symbols.}

\item{type}{specifies if the graph should use color or symbols. The standard setting is symbols.}

\item{plot_title}{specifies the main title in the graph.}

\item{tl.cex}{Numeric, for the size of text label.}

\item{tl.offset}{Numeric, for text label.}

\item{tl.srt}{Numeric, for text label, string rotation in degrees.}

\item{pal}{The colour vector representing the clusters.}

\item{alpha}{Factor modifying the opacity, alpha, typically in [0,1].}

\item{ps_power}{A power value to adjust point size.}

\item{col_size}{When type="col", the size of each point (maximum is 1).}

\item{cex.main}{Specify the size of the title text.}

\item{...}{specifies further parameters that can be passed on to the plot function.}
}
\description{
This is a function that can produce a Czekanowski's Diagram and present clustering findings.
}
\examples{
# Set data ####
# Not Cluster
czek = czek_matrix(mtcars)
# Exact Clustering
czek_exact = czek_matrix(mtcars, order = "GW", cluster = TRUE, num_cluster = 2, min.size = 2)

# Standard plot ############
plot(czek_exact)

# Edit diagram title
plot(czek, plot_title = "mtcars", cex.main = 2)

# Change point size ############
# Specify values
plot(czek, values = c(1, 0.8, 0.5, 0.2, 0))
plot(czek, values = grDevices::colorRampPalette(c("black", "red", "white"))(5))

# set point size for 'symbols' type by setting power value
plot(czek, type = "symbols", ps_power = 1)

# set point size for 'col' type
plot(czek, type = "col", col_size = 0.6)

# Specify type ############
plot(czek, type = "symbols")
plot(czek, type = "col")

# Edit cluster ############
# Edit colors
plot(czek_exact, pal = c("red", "blue"))
# Edit opacity
plot(czek_exact, alpha = 0.5)
# Fuzzy Clustering
## The below example will only work if you have FuzzyDBScan installed 
## (from GitHub or CRAN's archive). Otherwise the code stops.
## czek_fuzzy = czek_matrix(mtcars, order = "OLO", cluster = TRUE, num_cluster = 2,
## cluster_type = "fuzzy", min.size = 2, scale_bandwidth = 0.2)
# Standard plot ############
## plot.czek_matrix(czek_fuzzy)

}
