% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLOT_plotConvergence.R
\name{plotParamConvergence}
\alias{plotParamConvergence}
\title{Evolution of parameters}
\usage{
plotParamConvergence(output, var, ...)
}
\arguments{
\item{output}{object returned by \emph{mixtCompLearn} function from \emph{RMixtComp} or \emph{rmcMultiRun} function
from \emph{RMixtCompIO}}

\item{var}{name of the variable}

\item{...}{graphical parameters}
}
\description{
Plot the evolution of estimated parameters after the burn-in phase.
}
\examples{
if (requireNamespace("RMixtCompIO", quietly = TRUE)) {
  dataLearn <- list(
    var1 = as.character(c(rnorm(50, -2, 0.8), rnorm(50, 2, 0.8))),
    var2 = as.character(c(rnorm(50, 2), rpois(50, 8)))
  )

  model <- list(
    var1 = list(type = "Gaussian", paramStr = ""),
    var2 = list(type = "Poisson", paramStr = "")
  )

  algo <- list(
    nClass = 2,
    nInd = 100,
    nbBurnInIter = 100,
    nbIter = 100,
    nbGibbsBurnInIter = 100,
    nbGibbsIter = 100,
    nInitPerClass = 3,
    nSemTry = 20,
    confidenceLevel = 0.95,
    ratioStableCriterion = 0.95,
    nStableCriterion = 10,
    mode = "learn"
  )

  resLearn <-RMixtCompIO::rmcMultiRun(algo, dataLearn, model, nRun = 3)

  # plot
  plotParamConvergence(resLearn, "var1")
  plotParamConvergence(resLearn, "var2")
}

}
\seealso{
Other plot: 
\code{\link{heatmapClass}()},
\code{\link{heatmapTikSorted}()},
\code{\link{heatmapVar}()},
\code{\link{histMisclassif}()},
\code{\link{plot.MixtComp}()},
\code{\link{plotConvergence}()},
\code{\link{plotDataBoxplot}()},
\code{\link{plotDataCI}()},
\code{\link{plotDiscrimClass}()},
\code{\link{plotDiscrimVar}()},
\code{\link{plotProportion}()}
}
\author{
Quentin Grimonprez
}
\concept{plot}
