% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nexml_validate.R
\name{nexml_validate}
\alias{nexml_validate}
\title{validate nexml using the online validator tool}
\usage{
nexml_validate(
  file,
  schema = system.file("xsd/nexml.xsd", package = "RNeXML"),
  local = TRUE
)
}
\arguments{
\item{file}{path to the nexml file to validate}

\item{schema}{URL of schema (for fallback method only, set by default).}

\item{local}{logical, if TRUE we skip the online validator and rely only on pure XML-schema validation.  This may fail to detect invalid use of some semantic elements.}
}
\value{
TRUE if the file is valid, FALSE or error message otherwise
}
\description{
validate nexml using the online validator tool
}
\details{
Requires an internet connection if local=FALSE.  see http://www.nexml.org/nexml/phylows/validator for more information in debugging invalid files
}
\examples{
\dontrun{
data(bird.orders)
birds <- nexml_write(bird.orders, "birds_orders.xml")
nexml_validate("birds_orders.xml")
unlink("birds_orders.xml") # delete file to clean up
}
}
