% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_roc.R
\name{add_tpauc_concave_lower_bound}
\alias{add_tpauc_concave_lower_bound}
\alias{add_tpauc_partially_proper_lower_bound}
\alias{add_tpauc_under_chance_lower_bound}
\alias{tpauc_lower_bounds}
\alias{add_tpauc_lower_bound}
\title{Add TpAUC lower bound to a ROC plot}
\usage{
add_tpauc_concave_lower_bound(
  data,
  response = NULL,
  predictor = NULL,
  lower_threshold,
  upper_threshold,
  .condition = NULL,
  .label = NULL
)

add_tpauc_partially_proper_lower_bound(
  data,
  response = NULL,
  predictor = NULL,
  lower_threshold,
  upper_threshold,
  .condition = NULL,
  .label = NULL
)

add_tpauc_under_chance_lower_bound(
  data,
  response = NULL,
  predictor = NULL,
  lower_threshold,
  upper_threshold,
  .condition = NULL,
  .label = NULL
)

add_tpauc_lower_bound(
  data,
  response = NULL,
  predictor = NULL,
  lower_threshold,
  upper_threshold,
  .condition = NULL,
  .label = NULL
)
}
\arguments{
\item{data}{A data.frame or extension (e.g. a tibble) containing values for
predictors and response variables.}

\item{response}{A data variable which must be a factor, integer or character
vector representing the prediction outcome on each observation
(\emph{Gold Standard}).

If the variable presents more than two possible outcomes, classes or
categories:
\itemize{
\item The outcome of interest (the one to be predicted) will remain distinct.
\item All other categories will be combined into a single category.
}

New combined category represents the "absence" of the condition to predict.
See \code{.condition} for more information.}

\item{predictor}{A data variable which must be numeric, representing values
of a classifier or predictor for each observation.}

\item{lower_threshold, upper_threshold}{Two numbers between 0 and 1,
inclusive. These numbers represent lower and upper values of FPR region where
to calculate and plot lower bound.}

\item{.condition}{A value from response that represents class, category or
condition of interest which wants to be predicted.

If \code{NULL}, condition of interest will be selected automatically depending on
\code{response} type.

Once the class of interest is selected, rest of them will be collapsed in a
common category, representing the "absence" of the condition to be predicted.

See \code{vignette("selecting-condition")} for further information on how
automatic selection is performed and details on selecting the condition of
interest.}

\item{.label}{A string representing the name used in labels.

If \code{NULL}, variable name from \code{predictor} will be used as label.}
}
\value{
A ggplot layer instance object.
}
\description{
Calculate and plot lower bound defined by TpAUC specificity index.
\itemize{
\item \code{add_tpauc_lower_bound()} provides a upper level function which
automatically calculates curve shape and plots a lower bound that better fits
it.
}

Additionally, several lower level functions are provided to plot
specific lower bounds:
\itemize{
\item \code{add_tpauc_concave_lower_bound()}. Plot lower bound corresponding to a ROC
curve with concave shape in selected region.
\item \code{add_tpauc_partially_proper_lower_bound}. Plot lower bound corresponding to
a ROC curve with partially proper (presence of some hook) in
selected region.
\item \code{add_tpauc_under_chance_lower_bound}. Plot lower bound corresponding to
a ROC curve with a hook under chance line in selected region.
}
}
\examples{
plot_roc_curve(iris, response = Species, predictor = Sepal.Width) +
  add_tpauc_lower_bound(
    data = iris,
    response = Species,
    predictor = Sepal.Width,
    upper_threshold =  0.1,
    lower_threshold = 0
  )
}
