% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROlogit.R
\name{rologit}
\alias{rologit}
\title{Fit RO-logit model and obtain heuristic residuals}
\usage{
rologit(
  yvar,
  evar,
  cfdr = NULL,
  emod = NULL,
  svar,
  dat,
  method = "efron",
  initial.res.par = c(0, 0),
  plot = TRUE,
  ...
)
}
\arguments{
\item{yvar}{string. Name of outcome variable.}

\item{evar}{string (or vector of strings). Name of exposure(s).}

\item{cfdr}{string (or vector of strings). Names of confounder(s). Default is
\code{NULL}.}

\item{emod}{string (or vector of strings). Name of effect modifier(s).
Default is \code{NULL}.}

\item{svar}{string. Name of stratum variable. Use \code{NULL} to fit model
without stratification.}

\item{dat}{\code{data.frame}. Contains all the variables needed for the
analysis.}

\item{method}{string. Use Efron (\code{"efron"}) or Breslow
(\code{"breslow"}) method for handling ties in the outcome. The default is
\code{"efron"}. See \code{\link[survival]{coxph}} for details.}

\item{initial.res.par}{The initial values of the intercept and log(scale), to
be passed to the \code{optim} function. The default values are set to
\code{c(0, 0)}, yet users are recommended to try a few initial values to
make sure global optimum is reached.}

\item{plot}{logic. To plot the Q-Q plot for the heuristic residuals. Default
is \code{TRUE}.}

\item{...}{Other parameters to be passed to the \code{optim} function for the
second stage analysis.}
}
\value{
Returns a list containing \code{obj} (the RO-Logit model fitted using
  \code{coxph}), \code{hresid} (the vector of heuristic residuals),
  \code{logscale} (log of scale parameter of the heuristic residuals), and
  \code{coefficients} (a data.frame with estimated coefficients before and
  after scaling).
}
\description{
Fit RO-logit model and obtain heuristic residuals
}
\examples{
# Fit an RO-logit model to determine whether the glycaemic control of
# patients differs between medical and surgical wards.
data(inpat_bg)
# Divide patients into strata based on age, gender, duration of monitoring
# episodes, and frequency of daily BG measurements.
inpat_bg$group <- paste(inpat_bg$age_group, inpat_bg$sex, inpat_bg$los_group,
                        inpat_bg$bg_freq_group, sep = "|")
# Fit an RO-logit model with mean BG reading as the outcome and ward as the
# exposure:
obj <- rologit(yvar = "bg_mean", evar = "ward", svar = "group",
               dat = inpat_bg, initial.res.par = c(2, 2))
summary(obj)
}
\references{
\itemize{
 \item{Allison PD, Christakis NA. Logit-models for sets of ranked items.
   Sociological Methodology 1994, Vol 24. 1994;24:199-228.}
 \item{Beggs S, Cardell S, Hausman J. Assessing the Potential Demand for
   Electric Cars. J Econometrics. 1981;17:1-19.}
 \item{Tan CS, Støer NC, Chen Y, Andersson M, Ning Y, Wee HL, Khoo EY,
   Tai ES, Kao SL, Reilly M. A stratification approach using logit-based
   models for confounder adjustment in the study of continuous outcomes.
   Statistical methods in medical research. 2017 Jan 1:0962280217747309.}
 \item{Therneau TM, Grambsch PM. Modeling Survival Data: Extending the Cox
   Model: Springer New York; 2000.}
}
}
