% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presto_unnest.R
\name{presto_unnest}
\alias{presto_unnest}
\alias{presto_unnest.tbl_presto}
\title{Unnest array columns in Presto tables}
\usage{
presto_unnest(
  data,
  cols,
  ...,
  values_to = NULL,
  with_ordinality = FALSE,
  ordinality_to = NULL
)

\method{presto_unnest}{tbl_presto}(
  data,
  cols,
  ...,
  values_to = NULL,
  with_ordinality = FALSE,
  ordinality_to = NULL
)
}
\arguments{
\item{data}{A \code{tbl_presto} object}

\item{cols}{Column(s) to unnest. Currently only supports a single column.}

\item{...}{Additional arguments (currently unused)}

\item{values_to}{Name of column to store unnested values. If \code{NULL}, uses
the original column name with \code{"_elem"} appended (e.g., \code{arr} becomes
\code{arr_elem}).}

\item{with_ordinality}{If \code{TRUE}, includes an ordinality column with the
position of each element in the array.}

\item{ordinality_to}{Name of ordinality column when \code{with_ordinality = TRUE}.
Must be provided if \code{with_ordinality = TRUE}.}
}
\value{
A \code{tbl_presto} object with the array column unnested into rows.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Expands array columns into rows using Presto's \verb{CROSS JOIN UNNEST} syntax.
This is similar to \code{tidyr::unnest()} but works with Presto database tables.
}
\examples{
\dontrun{
# Connect to Presto
con <- DBI::dbConnect(RPresto::Presto(), ...)

# Create a table with an array column
DBI::dbExecute(con, "CREATE TABLE test (id BIGINT, arr ARRAY(BIGINT))")
DBI::dbExecute(con, "INSERT INTO test VALUES (1, ARRAY[10, 20, 30])")

# Unnest the array column
tbl(con, "test") \%>\%
  presto_unnest(arr) \%>\%
  collect()
# Without values_to, the unnested column is named "arr_elem"

# Or specify a custom name
tbl(con, "test") \%>\%
  presto_unnest(arr, values_to = "elem") \%>\%
  collect()
}
}
