% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rrinfBase}
\alias{rrinfBase}
\title{Generic residual randomization inference
This function provides the basis for all other rrinf* functions.}
\usage{
rrinfBase(y, X, g_or_clust, cover, num_R, control.tinv)
}
\arguments{
\item{y}{Vector of outcomes (length n)}

\item{X}{Covariate matrix (n x p). First column should be ones to include intercept.}

\item{g_or_clust}{Either \code{clustering} or an invariance function that transforms residuals.}

\item{cover}{Number from [0, 1] that denotes the confidence interval coverage (e.g., 0.95 denotes 95\%)}

\item{num_R}{Number of test statistic values to calculate in the randomization test (similar to no. of bootstrap samples).}

\item{control.tinv}{A \code{List} that determines the test inversion.}
}
\value{
Matrix that includes the confidence interval endpoints, and the interval midpoint estimate.
}
\description{
Generic residual randomization inference
This function provides the basis for all other rrinf* functions.
}
\details{
This function has similar funtionality as standard \link{confint}.
It does so by testing plausible values for each parameter. The plausible values can be controlled as follows.
For some parameter beta_i we will test successively

H0: beta_i = hat_beta_i - \code{num_se} * se_i

...up to...

H0: beta_i = hat_beta_i + \code{num_se} * se_i

broken in \code{num_breaks} intervals. Here, hat_beta_i is the OLS estimate of beta_i and se_i is the standard error.

The \code{g_or_clust} object should either be (i) a g-invariance function R^n -> R^n; or (ii)
a list(type, cl) where type=c("perm", "sign", "double") and cl=\code{clustering} (see \link{example_clustering} for details).


\url{https://www.ptoulis.com/residual-randomization}
}
