% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.grid.to.points}
\alias{rsaga.grid.to.points}
\alias{rsaga.grid.to.points.randomly}
\title{Convert SAGA grid file to point shapefile}
\usage{
rsaga.grid.to.points(
  in.grids,
  out.shapefile,
  in.clip.polygons,
  exclude.nodata = TRUE,
  type = "nodes",
  env = rsaga.env(),
  ...
)

rsaga.grid.to.points.randomly(in.grid, out.shapefile, freq, ...)
}
\arguments{
\item{in.grids}{Input: names of (possibly several) SAGA GIS grid files to be converted into a point shapefile.}

\item{out.shapefile}{Output: point shapefile (default extension: \code{.shp}). Existing files will be overwritten!}

\item{in.clip.polygons}{optional polygon shapefile to be used for clipping/masking an area}

\item{exclude.nodata}{logical (default: \code{TRUE}), in newer SAGA versions numeric (see Note below): skip 'nodata' grid cells?}

\item{type}{character string: \code{"nodes"}: create point shapefile of grid center points; \code{"cells"} (only supported by SAGA GIS 2.0.6+): create polygon shapefile with grid cell boundaries}

\item{env}{RSAGA geoprocessing environment created by \code{\link[=rsaga.env]{rsaga.env()}}; required by \code{rsaga.grid.to.points} to determine version-dependent SAGA module name and arguments}

\item{...}{Optional arguments to be passed to \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}}

\item{in.grid}{Input: SAGA grid file from which to sample.}

\item{freq}{integer >=1: sampling frequency: on average 1 out of 'freq' grid cells are selected}
}
\value{
The type of object returned depends on the \code{intern} argument passed to the \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}. For \code{intern=FALSE} it is a numerical error code (0: success), or otherwise (default) a character vector with the module's console output.
}
\description{
Convert SAGA grid file to point (or polygon) shapefile - either completely or only a random sample of grid cells.
}
\note{
These functions use modules \verb{Grid Cells to Points/Polygons} (previously called \verb{Grid Values to Points} and in some earlier versions \verb{Grid Values to Shapes}) and \verb{Grid Values to Points (randomly)} in SAGA library \code{shapes_grid}.

The SAGA 2.0.6+ version of this module is more flexible as it allows to create grid cell polygons instead of center points (see argument \code{type}).

Since somewhere between SAGA 9.0.0 and 9.3.3, the \code{NODATA} argument is numeric with values of 0: include all cells, 1: include cell if at least one grid provides data, and 2: exclude cell if at least one grid does not provide data. From 9.3.0 up, \code{exclude.nodata=TRUE} is interpreted as (and converted to) \code{1}.
}
\examples{
\dontrun{
# one point per grid cell, exclude nodata areas:
rsaga.grid.to.points("dem", "dempoints")
# take only every 20th point, but to not exclude nodata areas:
rsaga.grid.to.points.randomly("dem", "dempoints20", freq = 20)
}
}
\seealso{
\code{\link[=rsaga.add.grid.values.to.points]{rsaga.add.grid.values.to.points()}}
}
\author{
Alexander Brenning (R interface), Olaf Conrad (SAGA modules)
}
\keyword{interface}
\keyword{spatial}
