% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HistRSDAToEcdf.r
\name{HistRSDAToEcdf}
\alias{HistRSDAToEcdf}
\title{HistRSDAToEcdf}
\usage{
HistRSDAToEcdf(h)
}
\arguments{
\item{h}{A matrix of histograms}
}
\value{
Transformation in Ecdf object
}
\description{
HistRSDAToEcdf
}
\examples{
\dontrun{
 data("hardwoodBrito")
 Hardwood.histogram<-hardwoodBrito
 Hardwood.cols<-colnames(Hardwood.histogram)
 Hardwood.names<-row.names(Hardwood.histogram)
 M<-length(Hardwood.cols)
 N<-length(Hardwood.names)
 BIN.Matrix<-matrix(rep(3,N*M),nrow = N)
 pca.hist<-sym.histogram.pca(Hardwood.histogram,BIN.Matrix)
 Hardwood.quantiles.PCA.2<-quantiles.RSDA.KS(pca.hist$sym.hist.matrix.PCA,100)
 h<-Hardwood.quantiles.PCA.2[[1]][[1]]
 HistRSDAToEcdf(h)
}
}
\author{
Jorge Arce Garro
}
