% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_1.R
\name{sep.binom}
\alias{sep.binom}
\title{Binomial Population sensitivity}
\usage{
sep.binom(n, pstar, se = 1, sp = 1, dig = 5)
}
\arguments{
\item{n}{sample size = number of units tested (integer), scalar or vector}

\item{pstar}{design prevalence as a proportion (scalar or vector of same length as n)}

\item{se}{unit sensitivity of test (proportion), default = 1 (scalar or vector of same length as n)}

\item{sp}{unit specificity of test (proportion), default = 1 (scalar or vector of same length as n)}

\item{dig}{number of digits for rounding of results}
}
\value{
vector of population-level sensitivities
}
\description{
Calculates population sensitivity for detecting disease,
  assuming imperfect test sensitivity and specificity and representative sampling,
  using binomial distribution (assumes large or unknown population size and that
  cut-point number of reactors for a positive result = 1)
}
\examples{
# examples for sep.binom - checked
sep.binom(n=300, pstar = 0.02, se = 0.92)
tested<- seq(10,100, by=10)
prev<- 0.05
sens<- 0.9
sep.binom(tested, prev, sens)
}
\keyword{methods}
