% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/te_class.R
\name{print.transfer_entropy}
\alias{print.transfer_entropy}
\title{Prints a transfer-entropy result}
\usage{
\method{print}{transfer_entropy}(
  x,
  digits = 4,
  boot = TRUE,
  probs = c(0, 0.25, 0.5, 0.75, 1),
  tex = FALSE,
  ref = NA,
  file = NA,
  table = TRUE,
  ...
)
}
\arguments{
\item{x}{a transfer_entropy}

\item{digits}{the number of digits to display, defaults to 4}

\item{boot}{if the bootstrapped results should be printed, defaults to TRUE}

\item{probs}{numeric vector of quantiles for the bootstraps}

\item{tex}{if the data should be outputted as a TeX-string}

\item{ref}{the reference string of the LaTeX table (label) applies only if table = TRUE and tex = TRUE, defaults to FALSE}

\item{file}{a file where the results are printed to}

\item{table}{if the table environment should be printed as well (only applies if tex = TRUE), defaults to TRUE}

\item{...}{additional arguments, currently not in use}
}
\value{
invisible the text
}
\description{
Prints a transfer-entropy result
}
\examples{
# construct two time-series
set.seed(1234567890)
n <- 500
x <- rep(0, n + 1)
y <- rep(0, n + 1)

for (i in seq(n)) {
  x[i + 1] <- 0.2 * x[i] + rnorm(1, 0, 2)
  y[i + 1] <- x[i] + rnorm(1, 0, 2)
}

x <- x[-1]
y <- y[-1]

# Calculate Shannon's Transfer Entropy
te_result <- transfer_entropy(x, y, nboot = 100)

print(te_result)

# change the number of digits
print(te_result, digits = 10)

# disable boot-print
print(te_result, boot = FALSE)

# specify the quantiles of the bootstraps
print(te_result, probs = c(0, 0.1, 0.4, 0.5, 0.6, 0.9, 1))

# get LaTeX output:
print(te_result, tex = TRUE)

# set the reference label for LaTeX table
print(te_result, tex = TRUE, ref = "tab:te_result")

\dontrun{
# file output
print(te_result, file = "te_result_file.txt")
print(te_result, tex = TRUE, file = "te_result_file.tex")
}
}
