% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_rwnn.R
\name{boost_rwnn}
\alias{boost_rwnn}
\alias{boost_rwnn.formula}
\title{Boosting random weight neural networks}
\usage{
boost_rwnn(
  formula,
  data = NULL,
  n_hidden = c(),
  lambda = NULL,
  B = 100,
  epsilon = 0.1,
  method = NULL,
  type = NULL,
  control = list()
)

\method{boost_rwnn}{formula}(
  formula,
  data = NULL,
  n_hidden = c(),
  lambda = NULL,
  B = 100,
  epsilon = 0.1,
  method = NULL,
  type = NULL,
  control = list()
)
}
\arguments{
\item{formula}{A \link{formula} specifying features and targets used to estimate the parameters of the output layer.}

\item{data}{A data-set (either a \link{data.frame} or a \link[tibble]{tibble}) used to estimate the parameters of the output layer.}

\item{n_hidden}{A vector of integers designating the number of neurons in each of the hidden layers (the length of the list is taken as the number of hidden layers).}

\item{lambda}{The penalisation constant(s) passed to either \link{rwnn} or \link{ae_rwnn} (see \code{method} argument).}

\item{B}{The number of levels used in the boosting tree.}

\item{epsilon}{The learning rate.}

\item{method}{The penalisation type passed to \link{ae_rwnn}. Set to \code{NULL} (default), \code{"l1"}, or \code{"l2"}. If \code{NULL}, \link{rwnn} is used as the base learner.}

\item{type}{A string indicating whether this is a regression or classification problem.}

\item{control}{A list of additional arguments passed to the \link{control_rwnn} function.}
}
\value{
An \link{ERWNN-object}.
}
\description{
Use gradient boosting to create ensemble random weight neural network models.
}
\examples{
n_hidden <- 10

B <- 100
epsilon <- 0.1
lambda <- 0.01

m <- boost_rwnn(y ~ ., data = example_data, n_hidden = n_hidden,
                lambda = lambda, B = B, epsilon = epsilon)
}
\references{
Friedman J.H. (2001) "Greedy function approximation: A gradrient boosting machine." \emph{The Annals of Statistics}, 29, 1189-1232.
}
