% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rajive.R
\name{Rajive}
\alias{Rajive}
\title{Robust Angle based Joint and Individual Variation Explained}
\usage{
Rajive(
  blocks,
  initial_signal_ranks,
  full = TRUE,
  n_wedin_samples = 1000,
  n_rand_dir_samples = 1000,
  joint_rank = NA
)
}
\arguments{
\item{blocks}{List. A list of the data matrices.}

\item{initial_signal_ranks}{Vector. The initial signal rank estimates.}

\item{full}{Boolean. Whether or not to store the full J, I, E matrices or just their SVDs (set to FALSE to save memory).}

\item{n_wedin_samples}{Integer. Number of wedin bound samples to draw for each data matrix.}

\item{n_rand_dir_samples}{Integer. Number of random direction bound samples to draw.}

\item{joint_rank}{Integer or NA. User specified joint_rank. If NA will be estimated from data.}
}
\value{
The aJIVE decomposition.
}
\description{
Computes the robust aJIVE decomposition with parallel computation.
}
\examples{
\donttest{
n <- 50
pks <- c(100, 80, 50)
Y <- ajive.data.sim(K =3, rankJ = 3, rankA = c(7, 6, 4), n = n,
                   pks = pks, dist.type = 1)
initial_signal_ranks <-  c(7, 6, 4)
data.ajive <- list((Y$sim_data[[1]]), (Y$sim_data[[2]]), (Y$sim_data[[3]]))
ajive.results.robust <- Rajive(data.ajive, initial_signal_ranks)
}

}
