% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.functions.R
\name{ajive.data.sim}
\alias{ajive.data.sim}
\title{Simulation of data blocks}
\usage{
ajive.data.sim(
  K = 3,
  rankJ = 2,
  rankA = c(20, 15, 10),
  n = 100,
  pks,
  dist.type = 1,
  noise = 1
)
}
\arguments{
\item{K}{Integer. Number of data blocks.}

\item{rankJ}{Integer. Joint rank.}

\item{rankA}{Vector of Integers. Individual Ranks.}

\item{n}{Integer. Number of data points.}

\item{pks}{Vector of Integers. Number of variables in each block.}

\item{dist.type}{Integer. 1 for normal, 2 for uniform, 3 for exponential}

\item{noise}{Integer. Standard deviation in dist}
}
\value{
Xsim a list of simulated data matrices and true rank values
}
\description{
Simulates blocks of data with joint and individual structures
}
\examples{
n <- 20
p1 <- 10
p2 <- 8
p3 <- 5
JrankTrue <- 2
initial_signal_ranks <- c(5, 2, 2)
 Y <- ajive.data.sim(K =3, rankJ = JrankTrue,
 rankA = initial_signal_ranks,n = n,
 pks = c(p1, p2, p3), dist.type = 1)
}
