% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-random-brown-motion-geometric.R
\name{geometric_brownian_motion}
\alias{geometric_brownian_motion}
\title{Geometric Brownian Motion}
\usage{
geometric_brownian_motion(
  .num_walks = 25,
  .n = 100,
  .mu = 0,
  .sigma = 0.1,
  .initial_value = 100,
  .delta_time = 0.003,
  .dimensions = 1
)
}
\arguments{
\item{.num_walks}{Total number of simulations.}

\item{.n}{Total time of the simulation, how many \code{n} points in time.}

\item{.mu}{Expected return}

\item{.sigma}{Volatility}

\item{.initial_value}{Integer representing the initial value.}

\item{.delta_time}{Time step size.}

\item{.dimensions}{The default is 1. Allowable values are 1, 2 and 3.}
}
\value{
A tibble containing the generated random walks with columns depending
on the number of dimensions:
\itemize{
\item \code{walk_number}: Factor representing the walk number.
\item \code{step_number}: Step index.
\item \code{y}: If \code{.dimensions = 1}, the value of the walk at each step.
\item \code{x}, \code{y}: If \code{.dimensions = 2}, the values of the walk in two dimensions.
\item \code{x}, \code{y}, \code{z}: If \code{.dimensions = 3}, the values of the walk in three dimensions.
}

The following are also returned based upon how many dimensions there are and could be any of x, y and or z:
\itemize{
\item \code{cum_sum}: Cumulative sum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_prod}: Cumulative product of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_min}: Cumulative minimum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_max}: Cumulative maximum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_mean}: Cumulative mean of \code{dplyr::all_of(.dimensions)}.
}
}
\description{
Create a Geometric Brownian Motion.
}
\details{
Geometric Brownian Motion (GBM) is a statistical method for modeling
the evolution of a given financial asset over time. It is a type of stochastic
process, which means that it is a system that undergoes random changes over
time.

GBM is widely used in the field of finance to model the behavior of stock
prices, foreign exchange rates, and other financial assets. It is based on
the assumption that the asset's price follows a random walk, meaning that it
is influenced by a number of unpredictable factors such as market trends,
news events, and investor sentiment.

The equation for GBM is:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ dS/S = mdt + sdW
}\if{html}{\out{</div>}}

where S is the price of the asset, t is time, m is the expected return on the
asset, s is the volatility of the asset, and dW is a small random change in
the asset's price.

GBM can be used to estimate the likelihood of different outcomes for a given
asset, and it is often used in conjunction with other statistical methods to
make more accurate predictions about the future performance of an asset.

This function provides the ability of simulating and estimating the parameters
of a GBM process. It can be used to analyze the behavior of financial
assets and to make informed investment decisions.
}
\examples{

set.seed(123)
geometric_brownian_motion()

set.seed(123)
geometric_brownian_motion(.dimensions = 3) |>
  head() |>
  t()

}
\seealso{
Other Generator Functions: 
\code{\link{brownian_motion}()},
\code{\link{discrete_walk}()},
\code{\link{random_beta_walk}()},
\code{\link{random_binomial_walk}()},
\code{\link{random_cauchy_walk}()},
\code{\link{random_chisquared_walk}()},
\code{\link{random_displacement_walk}()},
\code{\link{random_exponential_walk}()},
\code{\link{random_f_walk}()},
\code{\link{random_gamma_walk}()},
\code{\link{random_geometric_walk}()},
\code{\link{random_hypergeometric_walk}()},
\code{\link{random_logistic_walk}()},
\code{\link{random_lognormal_walk}()},
\code{\link{random_multinomial_walk}()},
\code{\link{random_negbinomial_walk}()},
\code{\link{random_normal_drift_walk}()},
\code{\link{random_normal_walk}()},
\code{\link{random_poisson_walk}()},
\code{\link{random_smirnov_walk}()},
\code{\link{random_t_walk}()},
\code{\link{random_uniform_walk}()},
\code{\link{random_weibull_walk}()},
\code{\link{random_wilcox_walk}()},
\code{\link{random_wilcoxon_sr_walk}()}

Other Continuous Distribution: 
\code{\link{brownian_motion}()},
\code{\link{random_beta_walk}()},
\code{\link{random_cauchy_walk}()},
\code{\link{random_chisquared_walk}()},
\code{\link{random_exponential_walk}()},
\code{\link{random_f_walk}()},
\code{\link{random_gamma_walk}()},
\code{\link{random_logistic_walk}()},
\code{\link{random_lognormal_walk}()},
\code{\link{random_normal_drift_walk}()},
\code{\link{random_normal_walk}()},
\code{\link{random_t_walk}()},
\code{\link{random_uniform_walk}()},
\code{\link{random_weibull_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Continuous Distribution}
\concept{Generator Functions}
