% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-random-binomial-walk.R
\name{random_binomial_walk}
\alias{random_binomial_walk}
\title{Generate Multiple Random Binomial Walks in Multiple Dimensions}
\usage{
random_binomial_walk(
  .num_walks = 25,
  .n = 100,
  .size = 10,
  .prob = 0.5,
  .initial_value = 0,
  .samp = TRUE,
  .replace = TRUE,
  .sample_size = 0.8,
  .dimensions = 1
)
}
\arguments{
\item{.num_walks}{An integer specifying the number of random walks to generate. Default is 25.}

\item{.n}{An integer specifying the number of observations per walk. Must be greater than 0. Default is 100.}

\item{.size}{An integer specifying the number of trials (zero or more). Default is 10.}

\item{.prob}{A numeric value specifying the probability of success on each trial. Must be 0 <= .prob <= 1. Default is 0.5.}

\item{.initial_value}{A numeric value indicating the initial value of the walks. Default is 0.}

\item{.samp}{A logical value indicating whether to sample the binomial values. Default is TRUE.}

\item{.replace}{A logical value indicating whether sampling is with replacement. Default is TRUE.}

\item{.sample_size}{A numeric value between 0 and 1 specifying the proportion of \code{.n} to sample. Default is 0.8.}

\item{.dimensions}{An integer specifying the number of dimensions (1, 2, or 3). Default is 1.}
}
\value{
A tibble containing the generated random walks with columns depending on the number of dimensions:
\itemize{
\item \code{walk_number}: Factor representing the walk number.
\item \code{step_number}: Step index.
\item \code{y}: If \code{.dimensions = 1}, the value of the walk at each step.
\item \code{x}, \code{y}: If \code{.dimensions = 2}, the values of the walk in two dimensions.
\item \code{x}, \code{y}, \code{z}: If \code{.dimensions = 3}, the values of the walk in three dimensions.
}

The following are also returned based upon how many dimensions there are and could be any of x, y and or z:
\itemize{
\item \code{cum_sum}: Cumulative sum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_prod}: Cumulative product of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_min}: Cumulative minimum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_max}: Cumulative maximum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_mean}: Cumulative mean of \code{dplyr::all_of(.dimensions)}.
}

The tibble includes attributes for the function parameters.
}
\description{
The \code{random_binomial_walk} function generates multiple random walks using the binomial distribution via \code{rbinom()}.
The user can specify the number of walks, the number of steps in each walk, the number of trials, and the probability of success.
The function also allows for sampling a proportion of the steps and optionally sampling with replacement.
}
\details{
This function generates random walks where each step is drawn from the binomial distribution using \code{rbinom()}.
The user can control the number of walks, steps per walk, the number of trials (\code{size}), and the probability of success (\code{prob}).
The function supports 1, 2, or 3 dimensions, and augments the output with cumulative statistics for each walk.
Sampling can be performed with or without replacement, and a proportion of steps can be sampled if desired.
}
\examples{
set.seed(123)
random_binomial_walk()

set.seed(123)
random_binomial_walk(.dimensions = 2) |>
  head() |>
  t()

}
\seealso{
Other Generator Functions: 
\code{\link{brownian_motion}()},
\code{\link{discrete_walk}()},
\code{\link{geometric_brownian_motion}()},
\code{\link{random_beta_walk}()},
\code{\link{random_cauchy_walk}()},
\code{\link{random_chisquared_walk}()},
\code{\link{random_displacement_walk}()},
\code{\link{random_exponential_walk}()},
\code{\link{random_f_walk}()},
\code{\link{random_gamma_walk}()},
\code{\link{random_geometric_walk}()},
\code{\link{random_hypergeometric_walk}()},
\code{\link{random_logistic_walk}()},
\code{\link{random_lognormal_walk}()},
\code{\link{random_multinomial_walk}()},
\code{\link{random_negbinomial_walk}()},
\code{\link{random_normal_drift_walk}()},
\code{\link{random_normal_walk}()},
\code{\link{random_poisson_walk}()},
\code{\link{random_smirnov_walk}()},
\code{\link{random_t_walk}()},
\code{\link{random_uniform_walk}()},
\code{\link{random_weibull_walk}()},
\code{\link{random_wilcox_walk}()},
\code{\link{random_wilcoxon_sr_walk}()}

Other Discrete Distribution: 
\code{\link{discrete_walk}()},
\code{\link{random_displacement_walk}()},
\code{\link{random_geometric_walk}()},
\code{\link{random_hypergeometric_walk}()},
\code{\link{random_multinomial_walk}()},
\code{\link{random_negbinomial_walk}()},
\code{\link{random_poisson_walk}()},
\code{\link{random_smirnov_walk}()},
\code{\link{random_wilcox_walk}()},
\code{\link{random_wilcoxon_sr_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Discrete Distribution}
\concept{Generator Functions}
