#' Cancer Survival Times Data
#'
#' Survival times of cancer patients with advanced cancer of the stomach,
#' bronchus, colon, ovary or breast, whose treatment included supplemental
#' ascorbate.
#'
#' @format 17 obs. of 5 variables:
#' \describe{
#' \item{stomach}{survival times for stomach cancer patients}
#' \item{bronchus}{survival times for bronchus cancer patients}
#' \item{colon}{survival times for colon cancer patients}
#' \item{ovary}{survival times for ovary cancer patients}
#' \item{breast}{survival times for breast cancer patients}
#' }
#' @details
#' See the text for details on how to input this data directly from the file
#' PATIENT.DAT.
#'
#' @note This is the data from "PATIENT.DAT" with column headings added. As
#' input, the data is in wide format and should be stacked (long format) for
#' a one-way ANOVA. See the text for details.
#'
#' @source
#' Hand et al. (1994).
#'
#' @references
#' Cameron and Pauling (1978).
"PATIENT"
