\name{initGHMM}
\alias{initGHMM}

\title{
Random Initialization for a Hidden Markov Model with emissions modeled as continuous variables
}

\description{
Function used to generate a hidden Markov model with continuous variables and random parameters. This method allows using the univariate version of a Gaussian Mixture Model when setting m = 1. The code for the methods with categorical values or discrete data can be viewed in \code{"\link{initHMM}"} and \code{"\link{initPHMM}"}, respectively.  
}

\usage{
initGHMM(n,m)
}

\arguments{
  \item{n}{the number of hidden states to use.}
  \item{m}{the number of variables generated by the hidden states (Dimensionality of the bbserved vector).}
}

\value{
A \code{"\link{list}"} that contains the required values to specify the model.
\item{Model}{it specifies that the observed values are to be modeled as a Gaussian mixture model.}
\item{StateNames}{the set of hidden state names.}
\item{A}{the transition probabilities matrix.} 
\item{Mu}{a matrix of means of the observed variables (rows) in each states (columns).}
\item{Sigma}{a 3D matrix that has the covariance matrix of each state. The number of slices is equal to the maximum number of hidden states.} 
\item{Pi}{the initial probability vector.}
}

\references{
Cited references are listed on the \link{RcppHMM} manual page.
}

\examples{
n <- 3
m <- 5
model <- initGHMM(n, m)
print(model)
}

\keyword{initialization}
