% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RealSurvSim.R
\name{data_simul_Bootstr}
\alias{data_simul_Bootstr}
\title{Simulate Data Using Bootstrap Methods}
\usage{
data_simul_Bootstr(dat, n = NULL, type = "cond")
}
\arguments{
\item{dat}{A dataframe containing the original dataset, expected to include columns for event times (V1),
censoring indicators (V2), and group indicators (optional).}

\item{n}{Integer specifying the number of observations to simulate. If \code{NULL}, the function simulates the
same number of observations as in the original dataset. Defaults to \code{NULL}.}

\item{type}{Character string specifying the type of bootstrap method to be used. Supported types include
"cond" for conditional and "case" for case resampling. Defaults to "cond".}
}
\value{
A dataframe or a numeric vector of simulated values depending on the chosen bootstrap method.
- For "case" bootstrap
- For "cond" bootstrap, the arbitary n function does not work
}
\description{
Simulates event and censoring times from an original dataset using specified bootstrap methodologies. This function supports
conditional and case resampling bootstrap methods, allowing for flexible data simulation scenarios tailored to survival analysis.
}
\examples{
dat <- data.frame(
  V1 = rexp(100, rate = 0.1), # Time-to-event data
  V2 = sample(0:1, 100, replace = TRUE),
  V3 = sample(0:1, 100, replace = TRUE)# Event indicator (0 = censored, 1 = event)
)
simulated_case <- data_simul_Bootstr(dat = dat, n = 100, type = "case")
simulated_cond <- data_simul_Bootstr(dat = dat, type = "cond")
}
