% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MonteCarlo.R
\name{.MonteCarlo}
\alias{.MonteCarlo}
\title{Monte Carlo Draws}
\usage{
.MonteCarlo(
  statistic,
  alternative,
  FUN,
  B = 1000,
  rdist = stats::runif,
  Trows,
  Mcols,
  ...
)
}
\arguments{
\item{statistic}{Observed value of the statistic.}

\item{alternative}{A character string indicating the alternative hypothesis
and must be one of \code{"greater"}, \code{"less"} or \code{"two.sided"}.}

\item{FUN}{A function that computes the statistic.}

\item{B}{An integer specifying the number of replicates used in the Monte
Carlo approach.}

\item{rdist}{function that simulates continuous random variables, 
e.g., \code{\link{runif}} (fastest in \code{stats} package), 
\code{\link{rnorm}} or \code{\link{rexp}}.}

\item{Trows, Mcols}{Number of rows and columns respectively, of the desired 
sample \code{rdist}.}

\item{...}{Not used.}
}
\value{
Estimated p-value.
}
\description{
This function performs Monte Carlo simulations when needed,
  it is not developed for the use of the user.
}
\author{
Jorge Castillo-Mateo
}
\keyword{internal}
