% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/julia_backend.R
\name{benchmark_backends}
\alias{benchmark_backends}
\title{Benchmark Julia vs R Performance}
\usage{
benchmark_backends(data, method = "pelt", n_reps = 10, ...)
}
\arguments{
\item{data}{Test data.}

\item{method}{Method to benchmark.}

\item{n_reps}{Number of repetitions.}

\item{...}{Additional arguments for the method.}
}
\value{
Data frame with timing results (invisibly).
}
\description{
Compare execution time between Julia and R implementations.
}
\examples{
\donttest{
data <- c(rnorm(500), rnorm(500, 3))
benchmark_backends(data, method = "pelt", penalty = log(1000))
}
}
