% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_frequentist.R
\name{detect_pelt}
\alias{detect_pelt}
\title{Detect changepoints using enhanced PELT algorithm}
\usage{
detect_pelt(
  data,
  type = "both",
  penalty = "MBIC",
  min_segment = 2,
  robust = FALSE,
  correct_ar = FALSE,
  merge_close = NULL,
  ...
)
}
\arguments{
\item{data}{Numeric vector or matrix. For matrices, rows are observations.}

\item{type}{Type of change to detect: \code{"mean"}, \code{"var"}, or \code{"both"}.}

\item{penalty}{Penalty type (\code{"MBIC"}, \code{"BIC"}, \code{"AIC"}) or numeric value.}

\item{min_segment}{Minimum segment length (default: 2).}

\item{robust}{Logical or character. FALSE for standard, TRUE for moderate robustness,
or one of "mild", "moderate", "aggressive", "auto" for specific levels.}

\item{correct_ar}{Logical. Apply pre-whitening for autocorrelated data. Default: FALSE.}

\item{merge_close}{Integer or NULL. Merge changepoints within this distance. Default: NULL.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A list with components:
\describe{
\item{changepoints}{Integer vector of detected changepoint locations}
\item{n_changepoints}{Number of changepoints detected}
\item{cost}{Final cost value}
\item{ar_coefficient}{Estimated AR(1) coefficient (if \code{correct_ar = TRUE})}
\item{prewhitened}{Logical indicating if pre-whitening was applied}
\item{robust}{Logical indicating if robust estimation was used}
\item{robust_level}{Character indicating robustness level used}
\item{information_criterion}{Reserved for future use}
}
}
\description{
Pruned Exact Linear Time (PELT) algorithm for optimal changepoint detection
with enhancements for autocorrelated data and numerical stability.
}
\details{
This implementation includes enhancements over standard PELT:

\strong{Pre-whitening for autocorrelated data:} When \code{correct_ar = TRUE},
the function estimates the AR(1) coefficient and transforms the data via
\eqn{y'_t = y_t - \rho y_{t-1}} before applying PELT.

\strong{Configurable robustness:} The \code{robust} parameter accepts:
\itemize{
\item \code{FALSE}: Standard MLE-based estimation
\item \code{TRUE} or \code{"moderate"}: 10\\% winsorization, Huber k=1.0, Qn scale
\item \code{"mild"}: 5\\% winsorization, Huber k=1.345, MAD scale
\item \code{"aggressive"}: 15\\% winsorization, Tukey biweight, Qn scale
\item \code{"auto"}: Automatically select based on data characteristics
}
}
\examples{

data <- c(rnorm(100, 0), rnorm(100, 3))
result <- detect_pelt(data, type = "mean")


data_contaminated <- c(rnorm(100, 0), rnorm(100, 3))
data_contaminated[sample(200, 10)] <- rnorm(10, 0, 10)
result_robust <- detect_pelt(data_contaminated, robust = TRUE)


result_auto <- detect_pelt(data_contaminated, robust = "auto")

}
\references{
Killick, R., Fearnhead, P., and Eckley, I. A. (2012). Optimal detection of
changepoints with a linear computational cost. JASA, 107(500), 1590-1598.
}
