% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_frequentist.R
\name{wild_binary_segmentation}
\alias{wild_binary_segmentation}
\title{Wild Binary Segmentation}
\usage{
wild_binary_segmentation(
  data,
  type = "both",
  penalty = "BIC",
  min_segment = 2,
  n_changepoints = "multiple",
  M = 5000,
  threshold = NULL,
  ...
)
}
\arguments{
\item{data}{Numeric vector or matrix of time series data}

\item{type}{Type of change to detect: "mean", "variance", or "both"}

\item{penalty}{Penalty for model complexity: "BIC", "AIC", "MBIC", or numeric}

\item{min_segment}{Minimum segment length}

\item{n_changepoints}{Expected number of changepoints: "single", "multiple", or integer}

\item{M}{Number of random intervals to draw}

\item{threshold}{Detection threshold for CUSUM statistic. If NULL, automatically determined}

\item{...}{Additional arguments}
}
\value{
A list with:
\item{changepoints}{Vector of detected changepoint locations}
\item{n_changepoints}{Number of changepoints detected}
\item{information_criterion}{BIC value for the segmentation}
}
\description{
Detects multiple changepoints using the Wild Binary Segmentation algorithm.
Uses random intervals to improve detection in long time series.
}
\examples{
data <- c(rnorm(100), rnorm(100, mean = 2), rnorm(100))
result <- wild_binary_segmentation(data)

}
\references{
Fryzlewicz, P. (2014). Wild Binary Segmentation for multiple change-point detection.
Annals of Statistics, 42(6), 2243-2281.
}
