% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dAddW.R
\name{dAddW}
\alias{dAddW}
\alias{pAddW}
\alias{qAddW}
\alias{rAddW}
\alias{hAddW}
\title{The Additive Weibull distribution}
\usage{
dAddW(x, mu, sigma, nu, tau, log = FALSE)

pAddW(q, mu, sigma, nu, tau, lower.tail = TRUE, log.p = FALSE)

qAddW(p, mu, sigma, nu, tau, lower.tail = TRUE, log.p = FALSE)

rAddW(n, mu, sigma, nu, tau)

hAddW(x, mu, sigma, nu, tau)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{sigma}{parameter.}

\item{nu}{shape parameter.}

\item{tau}{shape parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dAddW} gives the density, \code{pAddW} gives the distribution 
function, \code{qAddW} gives the quantile function, \code{rAddW}
generates random deviates and \code{hAddW} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the Additive Weibull distribution
with parameters \code{mu}, \code{sigma}, \code{nu} and \code{tau}.
}
\details{
Additive Weibull Distribution with parameters \code{mu}, 
\code{sigma}, \code{nu} and \code{tau} has density given by

\eqn{f(x) = (\mu\nu x^{\nu - 1} + \sigma\tau x^{\tau - 1}) \exp({-\mu x^{\nu} - \sigma x^{\tau} }),}

for x > 0.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
curve(dAddW(x, mu=1.5, sigma=0.5, nu=3, tau=0.8), from=0.0001, to=2,
      col="red", las=1, ylab="f(x)")

## The cumulative distribution and the Reliability function
par(mfrow=c(1, 2))
curve(pAddW(x, mu=1.5, sigma=0.5, nu=3, tau=0.8),
      from=0.0001, to=2, col="red", las=1, ylab="F(x)")
curve(pAddW(x, mu=1.5, sigma=0.5, nu=3, tau=0.8, lower.tail=FALSE),
      from=0.0001, to=2, col="red", las=1, ylab="R(x)")

## The quantile function
p <- seq(from=0, to=0.99999, length.out=100)
plot(x=qAddW(p, mu=1.5, sigma=0.2, nu=3, tau=0.8), y=p, xlab="Quantile",
     las=1, ylab="Probability")
curve(pAddW(x, mu=1.5, sigma=0.2, nu=3, tau=0.8), 
      from=0, add=TRUE, col="red")

## The random function
hist(rAddW(n=10000, mu=1.5, sigma=0.2, nu=3, tau=0.8), freq=FALSE,
     xlab="x", las=1, main="")
curve(dAddW(x, mu=1.5, sigma=0.2, nu=3, tau=0.8),
      from=0.09, to=5, add=TRUE, col="red")

## The Hazard function
curve(hAddW(x, mu=1.5, sigma=0.2, nu=3, tau=0.8), from=0.001, to=1,
      col="red", ylab="Hazard function", las=1)

par(old_par) # restore previous graphical parameters
}
\references{
\insertRef{almalki2014modifications}{RelDists}

\insertRef{Xie1996}{RelDists}
}
\author{
Amylkar Urrea Montoya, \email{amylkar.urrea@udea.edu.co}
}
