% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Electoral_index.R
\name{Rae}
\alias{Rae}
\title{Disproportionality index of Rae - 1971 ("R")}
\usage{
Rae(votes, seats)
}
\arguments{
\item{votes}{It is a vector of integers, containing the votes of all the candidates.}

\item{seats}{It is a vector of integers, containing the seats obtained by each of the candidates.}
}
\value{
Returns the value obtained for the index
}
\description{
This index measures electoral disproportionality based on the result obtained in an election.
It has the disadvantage that it is highly influenced by the number of small parties that compete in
the elections. The formula used is as follows:
\deqn{R=\frac{\sum_{i=1}^{n}|E_{i}-V_{i}|}{n}}{R = (1/n)*sum(|Vi-Ei|)}
for \eqn{i = 1, 2, \ldots,n}

To compute its value, an integer vector corresponding to the votes obtained by each party and another with
the corresponding seats must be provided as parameters of the formula. The R code will be in charge of
calculating the corresponding percentages to obtain the index.
}
\section{Functions}{
\itemize{
\item \code{Rae}: indicators
}}

\section{Indicator}{
NA
}

\examples{
Rae(c(1200, 30, 4000),c(10,6,8))

}
