% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Electoral_index.R
\name{INP}
\alias{INP}
\title{Party Nationalization Index (INP)}
\usage{
INP(dat)
}
\arguments{
\item{dat}{Vector containing the proportions (as parts per unit) of the party's vote in each district}
}
\value{
A real number containing the value of the indicator.
}
\description{
Jones and Mainwaring (2003), proposed the calculation of this index
based on the Gini income concentration index. This index will take values between
0 and 1. A value close to 1 indicates that the party is highly nationalized, and a
value close to zero will indicate the opposite.

This index measures the degree of homogeneity of the votes a party receives in all
the electoral districts where it competes. In a very brief way, the calculation
formula for this indicator is as follows:

\deqn{IPN=1- Gini coefficient}{IPN=1- Gini coefficient}
}
\examples{

INP(c(0.15,0.22,0.24,0.26,0.27,0.27,0.27,0.32,0.33,0.34))

INP(c(0.3,0.1,0.2))

}
