% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Electoral_index.R
\name{INSP}
\alias{INSP}
\title{Nationalisation Index of the Political Party System (INSP)}
\usage{
INSP(datos)
}
\arguments{
\item{datos}{It is a data.frame with the first column containing the name of the electoral district,
the rest of the columns correspond to the parties presented and each column will contain the
number of votes that each party has obtained in the corresponding electoral district.}
}
\value{
A real number containing the value of the indicator.
}
\description{
This indicator is based on the nationalization index of each party. Its
calculation is computed using the aggregation of party nationalisation scores weighted
with the value of electoral weight, that is, the number of votes obtained. As with the Party
Nationalisation Index (INP), values close to 1 will indicate strong nationalisation and
values close to zero will indicate the opposite. The formula used for this
indicator is as follows:

\deqn{INSP=sum(INPi x pi)}{INSP=sum(INPi x pi)}

Where INPi is the nationalization index of party i, and pi is the number of votes obtained by party i.
}
\examples{

a <- data.frame(prov=c("Alava","Albacete","Valladolid"),
 PP=c(20,30,10),PSOE=c(34,12,45),   stringsAsFactors = FALSE)

INSP(a)


b<-data.frame(prov=c("1","2"),A=c(400,190),B=c(200,1000),stringsAsFactors = FALSE)
INSP(b)

}
