% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtotal_row.R
\name{subtotal_row}
\alias{subtotal_row}
\title{Subtotal Row Addition Function}
\usage{
subtotal_row(
  report,
  frame,
  vars = "Population",
  aggregator = "sum",
  exclude = numeric(0),
  agg_parameter = character(0),
  subtotal_label = "All"
)
}
\arguments{
\item{report}{A data report.}

\item{frame}{Data frame summarised by the data report.}

\item{vars}{Names of column(s) in the data frame aggregated in the data report.}

\item{aggregator}{Function to aggregate the data with.}

\item{exclude}{Vector of column indices determining which variables don't require subtotal rows.}

\item{agg_parameter}{Optional parameter for the aggregation function to use.}

\item{subtotal_label}{Label to be used for subtotal rows.}
}
\value{
The data report with subtotal rows included.
}
\description{
Adds subtotal rows to a data report.
}
\details{
The dataset and report are factorized,
and a series of reports with the same variables are then generated,
but with some variables replaced by a subtotal label,
which effectively concentrates all levels of those variables
into one subtotal row for those variables.
The subtotal reports are all combined with the original report,
and the combined report is sorted, sorting the subtotal label to the top for all variables.
}
\examples{
library(dplyr)

group_by(iris, Species, Petal.Width) \%>\%
summarise(sum(Petal.Length), .groups = "keep") \%>\%
subtotal_row(iris, vars = "Petal.Length")

group_by(iris, Species, Petal.Width) \%>\%
summarise(mean(Sepal.Width), .groups = "keep") \%>\%
subtotal_row(iris, vars = "Sepal.Width", aggregator = "mean")

group_by(mtcars, cyl, gear, carb) \%>\%
summarise(median(wt), median(hp), .groups = "keep") \%>\%
subtotal_row(mtcars, vars = c("wt", "hp"), aggregator = "median")

group_by(mtcars, cyl, gear, carb) \%>\%
summarise(Med_Weight = median(wt), Med_Hrspw = median(hp), .groups = "keep") \%>\%
subtotal_row(mtcars, vars = c("wt", "hp"), aggregator = "median", exclude = 1)

group_by(mtcars, vs, am, drat, carb) \%>\%
summarise(min(mpg), min(disp), min(carb), .groups = "keep") \%>\%
subtotal_row(mtcars, vars = c("mpg", "disp", "carb"),
aggregator = "min", exclude = c(2, 4), subtotal_label = "Min_Cars_Total", agg_parameter = "na.rm")
}
